/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.datasource;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aksw.jena_sparql_api.algebra.transform.TransformAssignToExtend;
import org.aksw.jena_sparql_api.algebra.utils.OpUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceDecorator;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.aksw.jenax.sparql.algebra.transform2.Evaluation;
import org.aksw.jenax.sparql.algebra.transform2.EvaluationCopy;
import org.aksw.jenax.sparql.algebra.transform2.Evaluator;
import org.aksw.jenax.stmt.core.SparqlStmt;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.aksw.jenax.util.backport.syntaxtransform.ElementTransformer;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.rdflink.RDFLinkModular;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.TransformCopy;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.iterator.QueryIteratorCloseable;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprFunctionOp;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.expr.ExprTransformCopy;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.service.enhancer.impl.ChainingServiceExecutorBulkServiceEnhancer;
import org.apache.jena.sparql.service.enhancer.init.ServiceEnhancerInit;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransform;
import org.apache.jena.sparql.syntax.syntaxtransform.ElementTransformCopyBase;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfDataSourceWithLocalLateral
extends RDFDataSourceWrapperBase<RDFDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(RdfDataSourceWithLocalLateral.class);
    public static final String REMOTE_IRI = "env://REMOTE";
    public static final Node REMOTE_NODE = NodeFactory.createURI((String)"env://REMOTE");
    protected Dataset proxyDataset;
    protected PolyfillLateralConfig config;

    private static int parseInt(String str, int fallbackValue) {
        return str.isEmpty() ? fallbackValue : Integer.parseInt(str);
    }

    public static Node createServiceIri(int bulkSize, int concurrentSlots) {
        return NodeFactory.createURI((String)String.format("loop+scoped:concurrent+%d-%d:bulk+%d:", concurrentSlots, bulkSize, bulkSize));
    }

    public static void main(String[] args) {
        Query a = QueryFactory.create((String)"PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nPREFIX lgdo: <http://linkedgeodata.org/ontology/>\nSELECT * {\n  { SELECT # DISTINCT\n      ?t\n    {\n      ?t a ?c .\n      # FILTER (?c IN (rdfs:Class, owl:Class))\n      # FILTER(isURI(?t)) FILTER(STRSTARTS(STR(?t), STR(lgdo:)))\n    }\n    #ORDER BY ?t\n    LIMIT 5\n  }\n  LATERAL {\n    ?t a ?c\n    FILTER NOT EXISTS { SELECT * { ?s a ?t } LIMIT 2 }\n    # { SELECT * { ?s a ?t } LIMIT 2 }\n  }\n}\n");
        Query b = OpRewriteInjectRemoteOps.rewriteQuery(a);
        System.out.println(b);
    }

    public static void mainX(String[] args) {
        for (int i = 0; i < 10; ++i) {
            RdfDataSourceWithLocalLateral.mainActual(args);
        }
    }

    public static void mainActual(String[] args) {
        int resultSetSize;
        String queryStr = "PREFIX dcat: <http://www.w3.org/ns/dcat#>\nPREFIX void: <http://rdfs.org/ns/void#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT * {\n  { SELECT * { GRAPH ?g { ?s a dcat:Dataset } } LIMIT 100 }\n  LATERAL {\n    { SELECT * { GRAPH ?g { ?s a dcat:Dataset . ?s owl:sameAs ?v . ?v a void:Dataset . ?v void:classPartition ?vcp } } LIMIT 10 }\n    # LATERAL { SELECT ?g ?vcp (COUNT(*) AS ?ppCount) { GRAPH ?g { ?vcp void:propertyPartition ?vcppp } } GROUP BY ?g ?vcp}\n  }\n}\n";
        queryStr = "PREFIX rdfs: <http://www.w3.org/2000/01/rdf-schema#>\nPREFIX owl: <http://www.w3.org/2002/07/owl#>\nSELECT * {\n  { SELECT DISTINCT ?t { ?t a ?c . FILTER (?c IN (rdfs:Class, owl:Class)) FILTER(isURI(?t)) } LIMIT 100 }\n  LATERAL {\n    { SELECT * { ?s a ?t } LIMIT 2 }\n  }\n}\n";
        final int[] counter = new int[]{0};
        Query query = QueryFactory.create((String)queryStr);
        RDFDataSource coreX = () -> RDFConnection.connect((String)"http://linkedgeodata.org/sparql");
        RDFDataSource core = () -> RDFConnectionUtils.wrapWithQueryTransform(coreX.getConnection(), null, qe -> new QueryExecWrapperBase<QueryExec>(qe){

            @Override
            public void beforeExec() {
                counter[0] = counter[0] + 1;
                System.err.println(Thread.currentThread().getName() + ": Request #" + counter[0] + ": " + this.getDelegate().getQueryString());
            }
        });
        RdfDataSourceWithLocalLateral dataSource = RdfDataSourceWithLocalLateral.wrap(core, new PolyfillLateralConfig(10, 10));
        Query rewritten = OpRewriteInjectRemoteOps.rewriteQuery(query);
        Stopwatch sw = Stopwatch.createStarted();
        try (RDFConnection conn = dataSource.getConnection();
             QueryExecution qe = conn.query(rewritten);){
            ServiceEnhancerInit.wrapOptimizer((Context)qe.getContext());
            ResultSetRewindable rs = qe.execSelect().rewindable();
            resultSetSize = rs.size();
            rs.reset();
            ResultSetFormatter.outputAsJSON((ResultSet)rs);
        }
        System.out.println("Done - Remote requests: " + counter[0] + " - resultSetSize: " + resultSetSize + " - time: " + sw.elapsed(TimeUnit.MILLISECONDS) + "ms");
    }

    public RdfDataSourceWithLocalLateral(RDFDataSource delegate, PolyfillLateralConfig config) {
        super(delegate);
        this.proxyDataset = RdfDataSourceWithLocalLateral.createProxyDataset(delegate);
        this.config = config;
    }

    public static RdfDataSourceWithLocalLateral wrap(RDFDataSource delegate) {
        return new RdfDataSourceWithLocalLateral(delegate, null);
    }

    public static RdfDataSourceWithLocalLateral wrap(RDFDataSource delegate, PolyfillLateralConfig config) {
        return new RdfDataSourceWithLocalLateral(delegate, config);
    }

    public static Dataset createProxyDataset(RDFDataSource delegate) {
        Dataset result = DatasetFactory.create();
        ServiceExecutorRegistry registry = new ServiceExecutorRegistry();
        registry.getBulkChain().add(new ChainingServiceExecutorBulkServiceEnhancer());
        ServiceEnhancerInit.registerServiceExecutorSelf((ServiceExecutorRegistry)registry);
        registry.addSingleLink((opExec, opOrig, binding, execCxt, chain) -> {
            QueryIterator r;
            if (opExec.getService().equals((Object)REMOTE_NODE)) {
                OpService finalOp = (OpService)Transformer.transform((Transform)TransformAssignToExtend.get(), (Op)opExec);
                RDFConnection base = delegate.getConnection();
                r = RDFConnectionUtils.execService(binding, execCxt, finalOp, base, true, true);
                r = new QueryIteratorCloseable(r, () -> ((RDFConnection)base).close());
            } else {
                r = chain.createExecution(opExec, opOrig, binding, execCxt);
            }
            return r;
        });
        ServiceExecutorRegistry.set((Context)result.getContext(), (ServiceExecutorRegistry)registry);
        return result;
    }

    protected SparqlStmt rewriteStatement(SparqlStmt stmt) {
        SparqlStmt result;
        if (stmt.isQuery()) {
            Query a = stmt.getQuery();
            Query b = OpRewriteInjectRemoteOps.rewriteQuery(a);
            Query c = this.config == null ? b : QueryUtils.applyElementTransform((Query)b, elt -> ElementTransformer.transform((Element)elt, (ElementTransform)new ElementTransformLateralToBulk(this.config)));
            result = new SparqlStmtQuery(c);
        } else {
            result = stmt;
        }
        return result;
    }

    @Override
    public RDFConnection getConnection() {
        RDFConnection proxyConn = RDFConnection.connect((Dataset)this.proxyDataset);
        RDFConnection originalConn = this.getDelegate().getConnection();
        RDFLink originalLink = RDFLinkAdapter.adapt((RDFConnection)originalConn);
        RDFLinkModular hybridLink = new RDFLinkModular((LinkSparqlQuery)RDFLinkAdapter.adapt((RDFConnection)proxyConn), (LinkSparqlUpdate)originalLink, (LinkDatasetGraph)originalLink);
        RDFLink finalLink = RDFLinkUtils.wrapWithQueryTransform((RDFLink)hybridLink, q -> this.rewriteStatement((SparqlStmt)new SparqlStmtQuery(q)).getQuery(), qe -> {
            ServiceEnhancerInit.wrapOptimizer((Context)qe.getContext());
            return qe;
        });
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)finalLink);
        return result;
    }

    public static Op wrapWithRemote(Op op) {
        OpService result = new OpService(REMOTE_NODE, op, false);
        return result;
    }

    public static class OpRewriteInjectRemoteOps
    implements EvaluationCopy<Map.Entry<Op, Boolean>> {
        public static Query rewriteQuery(Query query) {
            OpRewriteInjectRemoteOps xform = new OpRewriteInjectRemoteOps();
            Query result = QueryUtils.applyOpTransform((Query)query, arg_0 -> OpRewriteInjectRemoteOps.lambda$rewriteQuery$0(query, (Evaluation)xform, arg_0));
            return result;
        }

        public Map.Entry<Op, Boolean> eval(OpExtend op, Map.Entry<Op, Boolean> subOp) {
            return (Map.Entry)super.eval(op, subOp);
        }

        public Map.Entry<Op, Boolean> eval(OpFilter op, Map.Entry<Op, Boolean> subOp) {
            return (Map.Entry)super.eval(op, subOp);
        }

        public Map.Entry<Op, Boolean> eval(OpService op, Map.Entry<Op, Boolean> subOp) {
            return Map.entry(op, true);
        }

        public Map.Entry<Op, Boolean> eval(OpLateral op, Map.Entry<Op, Boolean> left, Map.Entry<Op, Boolean> right) {
            Map.Entry<Op, Boolean> result = this.evalAny((Op)op, Arrays.asList(left, right), true);
            return result;
        }

        public Map.Entry<Op, Boolean> evalAny(Op op, List<Map.Entry<Op, Boolean>> args) {
            Map.Entry<Op, Boolean> result = this.evalAny(op, args, false);
            return result;
        }

        public Map.Entry<Op, Boolean> evalAny(Op op, List<Map.Entry<Op, Boolean>> args, boolean forceAllRemote) {
            Map.Entry<Op, Boolean> result;
            Set localAndRemote = args.stream().map(Map.Entry::getValue).distinct().collect(Collectors.toSet());
            boolean anyRemote = localAndRemote.contains(Boolean.TRUE);
            if (forceAllRemote || anyRemote) {
                List newArgs = args.stream().map(arg -> {
                    Op subOp = (Op)arg.getKey();
                    Op r = (Boolean)arg.getValue() != false ? subOp : RdfDataSourceWithLocalLateral.wrapWithRemote(subOp);
                    return r;
                }).collect(Collectors.toList());
                result = Map.entry(OpUtils.copy((Op)op, newArgs), true);
            } else {
                List newArgs = args.stream().map(Map.Entry::getKey).collect(Collectors.toList());
                result = Map.entry(OpUtils.copy((Op)op, newArgs), false);
            }
            return result;
        }

        private static /* synthetic */ Op lambda$rewriteQuery$0(Query query, Evaluation xform, Op op) {
            Map.Entry tmp;
            Op r;
            if (logger.isDebugEnabled()) {
                logger.debug("LocalLateral - OriginalQuery:\n" + String.valueOf(query));
            }
            Op op2 = r = Boolean.FALSE.equals((tmp = (Map.Entry)Evaluator.evaluateSkipService((Evaluation)xform, (Op)op)).getValue()) ? RdfDataSourceWithLocalLateral.wrapWithRemote(op) : (Op)tmp.getKey();
            if (logger.isDebugEnabled()) {
                logger.debug("LocalLateral - RewrittenQuery:\n" + String.valueOf(query));
            }
            return r;
        }
    }

    public record PolyfillLateralConfig(int bulkSize, int concurrentSlots) {
        public static PolyfillLateralConfig parse(String val) {
            return PolyfillLateralConfig.parse(val, "-");
        }

        public static PolyfillLateralConfig parse(String val, String separator) {
            String[] parts;
            String v;
            Preconditions.checkArgument((!separator.isEmpty() ? 1 : 0) != 0, (Object)"Separator must not be empty");
            int bulkSize = 10;
            int concurrentSlots = 0;
            String string = v = val == null ? "" : val.toLowerCase().trim();
            if (!v.isEmpty() && (parts = v.split(separator, 2)).length > 0) {
                bulkSize = RdfDataSourceWithLocalLateral.parseInt(parts[0].trim(), 10);
                Preconditions.checkArgument((bulkSize > 0 ? 1 : 0) != 0, (Object)"Bulk size must be greater than 0.");
                if (parts.length > 1) {
                    concurrentSlots = RdfDataSourceWithLocalLateral.parseInt(parts[1].trim(), 0);
                    Preconditions.checkArgument((bulkSize > 0 ? 1 : 0) != 0, (Object)"Concurrent slots must be greater than or equal to 0.");
                }
            }
            return new PolyfillLateralConfig(bulkSize, concurrentSlots);
        }
    }

    public static class ElementTransformLateralToBulk
    extends ElementTransformCopyBase {
        protected Node serviceIri;

        public ElementTransformLateralToBulk(PolyfillLateralConfig config) {
            this(config.bulkSize(), config.concurrentSlots());
        }

        public ElementTransformLateralToBulk(int bulkSize, int concurrentSlots) {
            Preconditions.checkArgument((bulkSize > 0 ? 1 : 0) != 0, (Object)"Bulk size must be at least 1.");
            Preconditions.checkArgument((concurrentSlots >= 0 ? 1 : 0) != 0, (Object)"Number of concurrent slots must not be less than 0.");
            this.serviceIri = this.createServiceIri(bulkSize, concurrentSlots);
        }

        protected Node createServiceIri(int bulkSize, int concurrentSlots) {
            return RdfDataSourceWithLocalLateral.createServiceIri(bulkSize, concurrentSlots);
        }

        public Element transform(ElementLateral el, Element elt1) {
            return new ElementService(this.serviceIri, elt1, false);
        }
    }

    public class ExprTransformApplyElementTransform
    extends ExprTransformCopy {
        private final ElementTransform transform;

        public ExprTransformApplyElementTransform(ElementTransform transform) {
            this(transform, false);
        }

        public ExprTransformApplyElementTransform(ElementTransform transform, boolean alwaysDuplicate) {
            super(alwaysDuplicate);
            this.transform = transform;
        }

        public Expr transform(ExprFunctionOp funcOp, ExprList args, Op opArg) {
            Element el2 = ElementTransformer.transform((Element)funcOp.getElement(), (ElementTransform)this.transform, (ExprTransform)this);
            if (el2 == funcOp.getElement()) {
                return super.transform(funcOp, args, opArg);
            }
            if (funcOp instanceof E_Exists) {
                return new E_Exists(el2);
            }
            if (funcOp instanceof E_NotExists) {
                return new E_NotExists(el2);
            }
            throw new ARQInternalErrorException("Unrecognized ExprFunctionOp: \n" + String.valueOf(funcOp));
        }
    }

    public static class Factory
    implements RdfDataSourceDecorator {
        @Override
        public RDFDataSource decorate(RDFDataSource decoratee, Map<String, Object> options) {
            return RdfDataSourceWithLocalLateral.wrap(decoratee, null);
        }
    }

    public static class TransformLateralToBulk
    extends TransformCopy {
        protected Node serviceIri;

        public TransformLateralToBulk(int bulkSize, int concurrentSlots) {
            Preconditions.checkArgument((bulkSize > 0 ? 1 : 0) != 0, (Object)"Bulk size must be at least 1.");
            Preconditions.checkArgument((concurrentSlots >= 0 ? 1 : 0) != 0, (Object)"Number of concurrent slots must not be less than 0.");
            this.serviceIri = this.createServiceIri(bulkSize, concurrentSlots);
        }

        protected Node createServiceIri(int bulkSize, int concurrentSlots) {
            return RdfDataSourceWithLocalLateral.createServiceIri(bulkSize, concurrentSlots);
        }

        public Op transform(OpLateral opLateral, Op left, Op right) {
            return OpSequence.create((Op)left, (Op)new OpService(this.serviceIri, right, false));
        }
    }
}

