/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.linksource.track;

import org.aksw.jenax.dataaccess.sparql.linksource.track.DatasetGraphWithExecTracker;
import org.aksw.jenax.dataaccess.sparql.linksource.track.ExecTracker;
import org.aksw.jenax.dataaccess.sparql.linksource.track.PlanWrapperBase;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.Plan;
import org.apache.jena.sparql.engine.QueryEngineFactoryWrapper;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.util.Context;

public class QueryEngineFactoryExecTracker
extends QueryEngineFactoryWrapper {
    public boolean accept(Query query, DatasetGraph dataset, Context context) {
        boolean result = false;
        if (dataset instanceof DatasetGraphWithExecTracker) {
            DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)dataset;
            DatasetGraph backend = tracker.getWrapped();
            result = QueryEngineRegistry.findFactory((Query)query, (DatasetGraph)backend, (Context)context).accept(query, backend, context);
        }
        return result;
    }

    public Plan create(Query query, DatasetGraph dataset, Binding inputBinding, Context context) {
        DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)dataset;
        ExecTracker execTracker = ExecTracker.requireTracker(tracker.getContext());
        DatasetGraph next = tracker.getWrapped();
        Plan base = QueryEngineRegistry.findFactory((Query)query, (DatasetGraph)next, (Context)context).create(query, next, inputBinding, context);
        return new TrackingPlan(base, execTracker, context, query);
    }

    public boolean accept(Op op, DatasetGraph dataset, Context context) {
        boolean result = false;
        if (dataset instanceof DatasetGraphWithExecTracker) {
            DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)dataset;
            DatasetGraph next = tracker.getWrapped();
            result = QueryEngineRegistry.findFactory((Op)op, (DatasetGraph)next, (Context)context).accept(op, next, context);
        }
        return result;
    }

    public Plan create(Op op, DatasetGraph dataset, Binding inputBinding, Context context) {
        DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)dataset;
        ExecTracker execTracker = ExecTracker.requireTracker(tracker.getContext());
        DatasetGraph next = tracker.getWrapped();
        Plan base = QueryEngineRegistry.findFactory((Op)op, (DatasetGraph)next, (Context)context).create(op, next, inputBinding, context);
        return new TrackingPlan(base, execTracker, context, op);
    }

    private static class TrackingPlan
    extends PlanWrapperBase {
        protected ExecTracker execTracker;
        protected Object label;
        protected Context context;

        public TrackingPlan(Plan delegate, ExecTracker execTracker, Context context, Object label) {
            super(delegate);
            this.execTracker = execTracker;
            this.context = context;
            this.label = label;
        }

        @Override
        public QueryIterator iterator() {
            QueryIterator base = this.getDelegate().iterator();
            final long[] idRef = new long[]{-1L};
            QueryIteratorWrapper result = new QueryIteratorWrapper(base){
                protected Throwable t;
                {
                    super(arg0);
                    this.t = null;
                }

                protected boolean hasNextBinding() {
                    try {
                        return super.hasNextBinding();
                    }
                    catch (Throwable throwable) {
                        throwable.addSuppressed(new RuntimeException("Tracked exception"));
                        this.t = throwable;
                        throw throwable;
                    }
                }

                protected Binding moveToNextBinding() {
                    try {
                        return super.moveToNextBinding();
                    }
                    catch (Throwable throwable) {
                        throwable.addSuppressed(new RuntimeException("Tracked exception"));
                        this.t = throwable;
                        throw throwable;
                    }
                }

                protected void closeIterator() {
                    ExecTracker.CompletionRecord completionRecord = execTracker.remove(idRef[0], this.t);
                    System.err.println(completionRecord);
                    super.closeIterator();
                }
            };
            idRef[0] = this.execTracker.put(this.label, () -> ((QueryIterator)result).cancel());
            return result;
        }
    }
}

