/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.exec.update;

import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.exec.update.UpdateExecWrapperBase;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.update.UpdateProcessor;

public class UpdateExecWrapperTxn<T extends UpdateProcessor>
extends UpdateExecWrapperBase<T> {
    protected Transactional transactional;
    protected boolean startedTxnHere = false;
    protected Throwable seenThrowable = null;
    protected TxnType txnType;

    public UpdateExecWrapperTxn(T decoratee, Transactional transactional) {
        this(decoratee, transactional, TxnType.READ_PROMOTE);
    }

    public UpdateExecWrapperTxn(T decoratee, Transactional transactional, TxnType txnType) {
        super(decoratee);
        this.transactional = transactional;
        this.txnType = Objects.requireNonNull(txnType);
    }

    @Override
    public void beforeExec() {
        super.beforeExec();
        if (!this.transactional.isInTransaction()) {
            this.startedTxnHere = true;
            this.transactional.begin(this.txnType);
        }
    }

    @Override
    public void onException(Exception e) {
        this.seenThrowable = e;
        super.onException(e);
    }

    @Override
    public void afterExec() {
        if (this.startedTxnHere) {
            try {
                if (this.seenThrowable == null) {
                    this.transactional.commit();
                } else {
                    this.transactional.abort();
                }
            }
            finally {
                this.transactional.end();
            }
        }
    }

    public static <T extends UpdateProcessor> UpdateExec wrap(T decoratee, Transactional transactional) {
        return new UpdateExecWrapperTxn<T>(decoratee, transactional);
    }
}

