/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.exec.query;

import java.util.Iterator;
import org.aksw.jenax.arq.util.binding.BindingMapper;
import org.aksw.jenax.arq.util.binding.BindingMapperQuad;
import org.aksw.jenax.arq.util.binding.BindingMapperTriple;
import org.aksw.jenax.arq.util.syntax.QueryGenerationUtils;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactoryQuery;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.atlas.iterator.IteratorOnClose;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;

public class QueryExecUtils {
    public static IteratorCloseable<Binding> select(QueryExecFactoryQuery qef, Query query) {
        QueryExec qe = qef.create(query);
        RowSet rs = qe.select();
        IteratorOnClose result = Iter.onClose((Iterator)rs, () -> ((RowSet)rs).close());
        return result;
    }

    public static IteratorCloseable<Triple> findTriples(QueryExecFactoryQuery qef, Node s, Node p, Node o) {
        Triple triple = Triple.create((Node)s, (Node)p, (Node)o);
        Query query = QueryGenerationUtils.createQueryTriple((Triple)triple);
        BindingMapperTriple mapper = new BindingMapperTriple(triple);
        IteratorCloseable result = QueryExecUtils.execMapped(qef, query, mapper);
        return result;
    }

    public static IteratorCloseable<Quad> findQuads(QueryExecFactoryQuery qef, Node g, Node s, Node p, Node o) {
        Quad quad = new Quad(g, s, p, o);
        Query query = QueryGenerationUtils.createQueryQuad((Quad)quad);
        BindingMapperQuad mapper = new BindingMapperQuad(quad);
        IteratorCloseable result = QueryExecUtils.execMapped(qef, query, mapper);
        return result;
    }

    public static <T> IteratorCloseable<T> execMapped(QueryExecFactoryQuery qef, Query query, BindingMapper<T> bindingMapper) {
        QueryExec qe = qef.create(query);
        RowSet itBinding = qe.select();
        long[] id = new long[]{0L};
        IteratorCloseable result = (IteratorCloseable)Iter.map((Iterator)itBinding, b -> {
            long l = id[0];
            id[0] = l + 1L;
            return bindingMapper.apply(b, (Object)l);
        });
        return result;
    }
}

