/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.datasource;

import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.aksw.jena_sparql_api.algebra.expr.transform.ExprTransformVirtualBnodeUris;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.polyfill.datasource.RdfDataSourcePolyfill;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfDataSourceWithBnodeRewrite
extends RDFDataSourceWrapperBase<RDFDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(RdfDataSourceWithBnodeRewrite.class);
    public static final String AUTO = "auto";
    protected String givenProfileName;
    protected String derivedProfileName;
    protected ExprTransformVirtualBnodeUris.BnodeRewriteMode rewriteMode;
    protected Optional<ExprTransformVirtualBnodeUris> transformer = null;

    public RdfDataSourceWithBnodeRewrite(RDFDataSource delegate, String givenProfileName, ExprTransformVirtualBnodeUris.BnodeRewriteMode rewriteMode) {
        super(delegate);
        this.givenProfileName = givenProfileName;
        this.derivedProfileName = null;
        this.rewriteMode = Objects.requireNonNull(rewriteMode);
    }

    public String getGivenProfileName() {
        return this.givenProfileName;
    }

    public String getInferredProfileName() {
        return this.derivedProfileName;
    }

    public ExprTransformVirtualBnodeUris.BnodeRewriteMode getRewriteMode() {
        return this.rewriteMode;
    }

    public static ExprTransformVirtualBnodeUris getTransform(String profile, ExprTransformVirtualBnodeUris.BnodeRewriteMode rewriteMode) {
        Model model = RDFDataMgr.loadModel((String)"bnode-rewrites.ttl");
        SparqlStmtMgr.execSparql((Model)model, (String)"udf-inferences.rq");
        Set<String> activeProfiles = Set.of(profile);
        ExprTransformVirtualBnodeUris result = ExprTransformVirtualBnodeUris.createTransformFromUdfModel((Model)model, activeProfiles, (ExprTransformVirtualBnodeUris.BnodeRewriteMode)rewriteMode);
        return result;
    }

    @Override
    public RDFConnection getConnection() {
        RDFConnection result;
        RDFConnection base = this.getDelegate().getConnection();
        if (this.transformer == null) {
            this.derivedProfileName = AUTO.equalsIgnoreCase(this.givenProfileName) ? RdfDataSourcePolyfill.detectProfile(base) : this.givenProfileName;
            if (this.derivedProfileName != null) {
                ExprTransformVirtualBnodeUris tmp = RdfDataSourceWithBnodeRewrite.getTransform(this.derivedProfileName, this.rewriteMode);
                this.transformer = Optional.ofNullable(tmp);
            } else {
                this.transformer = Optional.empty();
            }
        }
        if (this.transformer.isPresent()) {
            result = RDFConnectionUtils.wrapWithQueryTransform(base, arg_0 -> ((ExprTransformVirtualBnodeUris)this.transformer.get()).rewrite(arg_0));
        } else {
            logger.warn("No bnode profile found - bnodes are not supported");
            result = base;
        }
        return result;
    }

    public static RdfDataSourceWithBnodeRewrite wrapWithAutoBnodeProfileDetection(RDFDataSource delegate, ExprTransformVirtualBnodeUris.BnodeRewriteMode rewriteMode) {
        return new RdfDataSourceWithBnodeRewrite(delegate, AUTO, rewriteMode);
    }
}

