/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.datasource;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Map;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderTransform;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderWrapperBase;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderTransform;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderWrapperBase;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransform;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapperBase;
import org.aksw.jenax.dataaccess.sparql.exec.update.UpdateExecWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSources;
import org.aksw.jenax.dataaccess.sparql.polyfill.datasource.RdfDataSourceWithSimpleCache;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;

public class RdfDataSourceTransforms {
    public static RdfDataSourceTransform decorateWithBuilderTransform(final QueryExecBuilderTransform queryBuilderTransform, final UpdateExecBuilderTransform updateBuilderTransform) {
        return rdfDataSource -> new RDFDataSourceWrapperBase<RDFDataSource>(rdfDataSource){

            @Override
            public RDFConnection getConnection() {
                RDFConnection result = RDFConnectionUtils.wrapWithBuilderTransform(super.getConnection(), queryBuilderTransform, updateBuilderTransform);
                return result;
            }
        };
    }

    public static RdfDataSourceTransform alwaysFail() {
        return base -> RDFDataSources.decorate(base, RdfDataSourceTransforms.decorateWithBuilderTransform(qeb -> new QueryExecBuilderWrapperBase((QueryExecBuilder)qeb){

            @Override
            public QueryExec build() {
                return new QueryExecWrapperBase<QueryExec>(super.build()){

                    @Override
                    public void beforeExec() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, ueb -> new UpdateExecBuilderWrapperBase((UpdateExecBuilder)ueb){

            @Override
            public UpdateExec build() {
                return new UpdateExecWrapperBase<UpdateExec>(super.build()){

                    @Override
                    public void beforeExec() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }));
    }

    public static RdfDataSourceTransform simpleCache() {
        Cache cache = Caffeine.newBuilder().recordStats().build();
        return ds -> new RdfDataSourceWithSimpleCache((RDFDataSource)ds, (Cache<Object, Object>)cache);
    }

    public static RdfDataSourceTransform simpleCache(long maxSize) {
        Cache cache = Caffeine.newBuilder().maximumSize(maxSize).recordStats().build();
        return ds -> new RdfDataSourceWithSimpleCache((RDFDataSource)ds, (Cache<Object, Object>)cache);
    }

    public static RdfDataSourceTransform macros(Map<String, UserDefinedFunctionDefinition> udfRegistry) {
        return org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(linkSource -> RDFLinkSources.wrapWithMacros(linkSource, udfRegistry));
    }
}

