/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataset.connection;

import org.aksw.jenax.dataaccess.sparql.execution.update.UpdateEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.DatasetRDFConnectionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.QueryExecDatasetBuilderEx;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.UpdateExecDatasetBuilderEx;
import org.aksw.jenax.dataaccess.sparql.factory.engine.query.QueryEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryWrapperBase;
import org.aksw.jenax.dataaccess.sparql.link.update.LinkSparqlUpdateWrapperBase;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkModular;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.util.Context;

public class DatasetRDFConnectionFactoryImpl
implements DatasetRDFConnectionFactory {
    protected QueryEngineFactoryProvider queryEngineFactoryProvider;
    protected UpdateEngineFactoryProvider updateEngineFactoryProvider;
    protected Context localContext;

    public DatasetRDFConnectionFactoryImpl(Context context, QueryEngineFactoryProvider queryEngineFactoryProvider, UpdateEngineFactoryProvider updateEngineFactoryProvider) {
        this.localContext = context;
        this.queryEngineFactoryProvider = queryEngineFactoryProvider;
        this.updateEngineFactoryProvider = updateEngineFactoryProvider;
    }

    protected RDFLink connectLink(final DatasetGraph dataset) {
        RDFLink baseLink = RDFLink.connect((DatasetGraph)dataset);
        LinkSparqlQueryWrapperBase queryLink = new LinkSparqlQueryWrapperBase((LinkSparqlQuery)baseLink){

            @Override
            public QueryExecBuilder newQuery() {
                return new QueryExecDatasetBuilderEx(dataset, DatasetRDFConnectionFactoryImpl.this.queryEngineFactoryProvider).context(DatasetRDFConnectionFactoryImpl.this.localContext);
            }
        };
        LinkSparqlUpdateWrapperBase updateLink = new LinkSparqlUpdateWrapperBase((LinkSparqlUpdate)baseLink){

            public UpdateExecBuilder newUpdate() {
                return new UpdateExecDatasetBuilderEx(dataset, DatasetRDFConnectionFactoryImpl.this.updateEngineFactoryProvider).context(DatasetRDFConnectionFactoryImpl.this.localContext);
            }
        };
        RDFLinkModular result = new RDFLinkModular((LinkSparqlQuery)queryLink, (LinkSparqlUpdate)updateLink, (LinkDatasetGraph)baseLink);
        return result;
    }

    @Override
    public RDFConnection connect(Dataset dataset) {
        RDFLink link = this.connectLink(dataset.asDatasetGraph());
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)link);
        return result;
    }
}

