/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.execution.query;

import java.util.Optional;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.util.Context;

public interface QueryExecutionWrapper
extends QueryExecution {
    public QueryExecution getDelegate();

    default public Optional<QueryExecution> tryGetDelegate() {
        QueryExecution delegate = this.getDelegate();
        return Optional.ofNullable(delegate);
    }

    default public Dataset getDataset() {
        return this.getDelegate().getDataset();
    }

    default public Context getContext() {
        return this.tryGetDelegate().map(QueryExecution::getContext).orElse(null);
    }

    default public Query getQuery() {
        return this.getDelegate().getQuery();
    }

    default public void abort() {
        this.getDelegate().abort();
    }

    default public void close() {
        this.tryGetDelegate().ifPresent(QueryExecution::close);
    }

    default public long getTimeout1() {
        return this.getDelegate().getTimeout1();
    }

    default public long getTimeout2() {
        return this.getDelegate().getTimeout2();
    }

    default public boolean isClosed() {
        return this.getDelegate().isClosed();
    }

    default public <X> X unwrap(Class<X> clazz) {
        QueryExecutionWrapper result = this.getClass().isAssignableFrom(clazz) ? this : QueryExecutionWrapper.unwrap(clazz, this.getDelegate());
        return (X)result;
    }

    public static <X> X unwrap(Class<X> clazz, QueryExecution qe) {
        X tmp;
        X result = tmp = qe instanceof QueryExecutionWrapper ? (X)((QueryExecutionWrapper)qe).unwrap(clazz) : null;
        return result;
    }
}

