/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.engine;

import java.io.Closeable;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngineSimple;
import org.aksw.jenax.dataaccess.sparql.engine.ServiceControl;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineDecorator;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceOverDatasetGraph;
import org.apache.jena.sparql.core.DatasetGraph;

public class RDFEngines {
    public static RDFEngine of(RDFLinkSource linkSource) {
        return new RDFEngineSimple(linkSource, null);
    }

    public static RDFEngine of(RDFLinkSource linkSource, AutoCloseable closeAction) {
        return new RDFEngineSimple(linkSource, closeAction);
    }

    public static RDFEngine of(RDFLinkSource linkSource, ServiceControl service, AutoCloseable closeAction) {
        return new RDFEngineSimple(linkSource, service, closeAction);
    }

    public static RDFEngine of(DatasetGraph datasetGraph) {
        return RDFEngines.of(datasetGraph, true);
    }

    public static RDFEngine of(DatasetGraph datasetGraph, boolean closeOnDelete) {
        RDFLinkSourceOverDatasetGraph linkSource = new RDFLinkSourceOverDatasetGraph(datasetGraph);
        Closeable closeAction = closeOnDelete ? () -> ((DatasetGraph)datasetGraph).close() : null;
        return RDFEngines.of(linkSource, closeAction);
    }

    public static <X extends RDFEngine> RDFEngineDecorator<X> decorate(X baseEngine) {
        return new RDFEngineDecorator<X>(baseEngine);
    }
}

