/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.transform;

import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.aksw.jenax.dataaccess.sparql.link.dataset.LinkDatasetGraphTransform;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransform;
import org.aksw.jenax.dataaccess.sparql.link.update.LinkSparqlUpdateTransform;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.LinkSparqlUpdate;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkModular;

public final class RDFLinkTransformModular
implements RDFLinkTransform {
    protected LinkSparqlQueryTransform queryTransform;
    protected LinkSparqlUpdateTransform updateTransform;
    protected LinkDatasetGraphTransform datasetTransform;

    public RDFLinkTransformModular(LinkSparqlQueryTransform queryTransform, LinkSparqlUpdateTransform updateTransform, LinkDatasetGraphTransform datasetTransform) {
        this.queryTransform = queryTransform;
        this.updateTransform = updateTransform;
        this.datasetTransform = datasetTransform;
    }

    public LinkSparqlQueryTransform getQueryTransform() {
        return this.queryTransform;
    }

    public LinkSparqlUpdateTransform getUpdateTransform() {
        return this.updateTransform;
    }

    public LinkDatasetGraphTransform getDatasetTransform() {
        return this.datasetTransform;
    }

    @Override
    public RDFLink apply(RDFLink base) {
        RDFLinkModular mod = RDFLinkUtils.asModular(base);
        LinkSparqlQuery q = mod.queryLink();
        LinkSparqlUpdate u = mod.updateLink();
        LinkDatasetGraph d = mod.datasetLink();
        if (this.queryTransform != null) {
            q = (LinkSparqlQuery)this.queryTransform.apply(q);
        }
        if (this.updateTransform != null) {
            u = (LinkSparqlUpdate)this.updateTransform.apply(u);
        }
        if (this.datasetTransform != null) {
            d = (LinkDatasetGraph)this.datasetTransform.apply(d);
        }
        RDFLinkModular result = new RDFLinkModular(q, u, d);
        return result;
    }

    public String toString() {
        return "RDFLinkTransformModular [queryTransform=" + String.valueOf(this.queryTransform) + ", updateTransform=" + String.valueOf(this.updateTransform) + ", datasetTransform=" + String.valueOf(this.datasetTransform) + "]";
    }
}

