/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.execution.query;

import java.util.function.Function;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecFactory;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RDFDataSources;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryOverQueryExecFactory;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryOverSparqlQueryConnection;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryQuery;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;

public class QueryExecutionFactories {
    protected static final Query datasetHashQuery = SparqlStmtMgr.loadQuery((String)"probe-dataset-hash-simple.rq");

    public static QueryExecutionFactory empty() {
        return QueryExecutionFactories.of(DatasetFactory.empty());
    }

    public static QueryExecutionFactory adapt(QueryExecFactory queryExecFactory) {
        return new QueryExecutionFactoryOverQueryExecFactory(queryExecFactory);
    }

    public static QueryExecutionFactory of(SparqlQueryConnection conn) {
        return new QueryExecutionFactoryOverSparqlQueryConnection(conn);
    }

    public static QueryExecutionFactory of(RDFDataSource dataSource) {
        return new QueryExecutionFactoryOverRdfDataSource(dataSource);
    }

    public static QueryExecutionFactory of(Dataset dataset) {
        return QueryExecutionFactories.of(RDFDataSources.of(dataset));
    }

    public static String fetchDatasetHash(QueryExecutionFactoryQuery qef) {
        String result = QueryExecutionUtils.fetchNode(qef::createQueryExecution, (Query)datasetHashQuery).map(Node::getLiteralLexicalForm).map(String::toLowerCase).orElse(null);
        return result;
    }

    public static <T> T exec(QueryExecutionFactoryQuery qef, Query query, Function<? super QueryExecution, T> qeToResult) {
        T tmp = null;
        try (QueryExecution qe = qef.createQueryExecution(query);){
            tmp = qeToResult.apply((QueryExecution)qe);
        }
        T result = tmp;
        return result;
    }

    public static class QueryExecutionFactoryOverRdfDataSource
    implements QueryExecutionFactory {
        protected RDFDataSource dataSource;

        public QueryExecutionFactoryOverRdfDataSource(RDFDataSource decoratee) {
            this.dataSource = decoratee;
        }

        @Override
        public QueryExecution createQueryExecution(String queryString) {
            final RDFConnection conn = this.dataSource.getConnection();
            return new QueryExecutionWrapperBase<QueryExecution>(conn.newQuery().parseCheck(false).query(queryString).build()){

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        conn.close();
                    }
                }
            };
        }

        @Override
        public QueryExecution createQueryExecution(Query query) {
            final RDFConnection conn = this.dataSource.getConnection();
            QueryExecution qe = conn.query(query);
            return new QueryExecutionWrapperBase<QueryExecution>(qe){

                @Override
                public void close() {
                    try {
                        super.close();
                    }
                    finally {
                        conn.close();
                    }
                }
            };
        }

        @Override
        public void close() throws Exception {
        }

        @Override
        public String getId() {
            return null;
        }

        @Override
        public String getState() {
            return null;
        }

        @Override
        public <T> T unwrap(Class<T> clazz) {
            return null;
        }
    }
}

