/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.execution.query;

import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;

public class QueryExecutionWrapperTxn<T extends QueryExecution>
extends QueryExecutionWrapperBase<T> {
    protected Transactional transactional;
    protected boolean startedTxnHere = false;
    protected Throwable seenThrowable = null;

    public QueryExecutionWrapperTxn(T decoratee, Transactional transactional) {
        super(decoratee);
        this.transactional = transactional;
    }

    @Override
    protected void beforeExec() {
        super.beforeExec();
        if (!this.transactional.isInTransaction()) {
            this.startedTxnHere = true;
            this.transactional.begin(ReadWrite.READ);
        }
    }

    @Override
    protected void onException(Exception e) {
        this.seenThrowable = e;
        super.onException(e);
    }

    @Override
    public void close() {
        if (this.startedTxnHere) {
            try {
                if (this.seenThrowable == null) {
                    this.transactional.commit();
                } else {
                    this.transactional.abort();
                }
            }
            finally {
                this.transactional.end();
            }
        }
        super.close();
    }

    public static <T extends QueryExecution> QueryExecution wrap(T decoratee, Transactional transactional) {
        return new QueryExecutionWrapperTxn<T>(decoratee, transactional);
    }
}

