/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.exec.query;

import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapperBase;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;

public class QueryExecWrapperTxn<T extends QueryExec>
extends QueryExecWrapperBase<T> {
    protected Transactional transactional;
    protected boolean startedTxnHere = false;
    protected Throwable seenThrowable = null;

    public QueryExecWrapperTxn(T delegate, Transactional transactional) {
        super(delegate);
        this.transactional = transactional;
    }

    @Override
    public void beforeExec() {
        super.beforeExec();
        if (!this.transactional.isInTransaction()) {
            this.startedTxnHere = true;
            this.transactional.begin(ReadWrite.READ);
        }
    }

    @Override
    public void onException(Exception e) {
        this.seenThrowable = e;
        super.onException(e);
    }

    @Override
    public void close() {
        if (this.startedTxnHere) {
            try {
                if (this.seenThrowable == null) {
                    this.transactional.commit();
                } else {
                    this.transactional.abort();
                }
            }
            finally {
                this.transactional.end();
            }
        }
        super.close();
    }

    public static <T extends QueryExec> QueryExec wrap(T decoratee, Transactional transactional) {
        return new QueryExecWrapperTxn<T>(decoratee, transactional);
    }
}

