/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.connection.reconnect;

import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.aksw.commons.util.exception.ExceptionUtilsAksw;
import org.aksw.commons.util.healthcheck.HealthcheckRunner;
import org.aksw.jenax.dataaccess.sparql.connection.query.SparqlQueryConnectionTmp;
import org.aksw.jenax.dataaccess.sparql.connection.reconnect.ConnectionLostException;
import org.aksw.jenax.dataaccess.sparql.connection.reconnect.ConnectionReestablishedException;
import org.aksw.jenax.dataaccess.sparql.execution.query.QueryExecutionWrapperBase;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Transactional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparqlQueryConnectionWithReconnect
implements SparqlQueryConnectionTmp {
    private static final Logger logger = LoggerFactory.getLogger(SparqlQueryConnectionWithReconnect.class);
    protected Callable<SparqlQueryConnection> dataConnectionSupplier;
    protected Callable<SparqlQueryConnection> probeConnectionSupplier;
    protected Query healthCheckQuery = QueryFactory.create((String)"SELECT * { ?s <http://www.example.org/rdf/type> <http://www.example.org/rdf/Resource> }");
    protected Supplier<HealthcheckRunner.Builder<?>> healthCheckBuilder;
    protected transient Exception connectionLostCause = null;
    protected transient int reconnectAttemptCount = 0;
    protected SparqlQueryConnection activeDelegate;

    public boolean isConnectionLost() {
        return this.connectionLostCause != null;
    }

    public SparqlQueryConnectionWithReconnect(Callable<SparqlQueryConnection> dataConnectionSupplier, Callable<SparqlQueryConnection> probeConnectionSupplier, Supplier<HealthcheckRunner.Builder<?>> healthCheckBuilder, SparqlQueryConnection activeDelegate) {
        this.dataConnectionSupplier = dataConnectionSupplier;
        this.probeConnectionSupplier = probeConnectionSupplier;
        this.activeDelegate = activeDelegate;
        this.healthCheckBuilder = healthCheckBuilder;
    }

    public int getReconnectAttemptCount() {
        return this.reconnectAttemptCount;
    }

    public static SparqlQueryConnectionWithReconnect create(Callable<SparqlQueryConnection> connectionSupplier) throws Exception {
        SparqlQueryConnection conn = connectionSupplier.call();
        return new SparqlQueryConnectionWithReconnect(connectionSupplier, connectionSupplier, () -> HealthcheckRunner.builder().setRetryCount(Long.MAX_VALUE).setInterval(5L, TimeUnit.SECONDS), conn);
    }

    @Override
    public Transactional getDelegate() {
        return this.activeDelegate;
    }

    protected void checkForConnectionLoss() {
        if (this.connectionLostCause != null) {
            throw new ConnectionLostException("connection lost", this.connectionLostCause);
        }
    }

    @Override
    public QueryExecution query(Query query) {
        this.checkForConnectionLoss();
        QueryExecution core = this.activeDelegate.query(query);
        QueryExecutionWithReconnect wrapped = new QueryExecutionWithReconnect(core);
        return wrapped;
    }

    protected boolean isConnectionProblemException(Throwable t) {
        return ExceptionUtilsAksw.isConnectionRefusedException((Throwable)t) || ExceptionUtilsAksw.isUnknownHostException((Throwable)t);
    }

    protected void forceCloseActiveConn() {
        try {
            if (this.activeDelegate != null) {
                this.activeDelegate.close();
            }
        }
        catch (Exception e) {
            logger.warn("Exception while attempting to close an apparently lost connecetion", (Throwable)e);
        }
        this.activeDelegate = null;
    }

    protected void tryRecovery() throws Exception {
        this.forceCloseActiveConn();
        boolean reuseProbeConn = this.probeConnectionSupplier == this.dataConnectionSupplier;
        SparqlQueryConnection probeConn = null;
        try {
            probeConn = this.probeConnectionSupplier.call();
            try (QueryExecution qe = probeConn.query(this.healthCheckQuery);){
                ResultSet rs = qe.execSelect();
                ResultSetFormatter.consume((ResultSet)rs);
            }
        }
        catch (Exception e) {
            if (probeConn != null) {
                probeConn.close();
            }
            throw new RuntimeException(e);
        }
        this.activeDelegate = reuseProbeConn ? probeConn : this.dataConnectionSupplier.call();
    }

    public void close() {
        this.activeDelegate.close();
    }

    protected void testForConnectionProblem(Exception e, int timestamp) {
        if (!this.isConnectionProblemException(e)) {
            throw new RuntimeException(e);
        }
        this.handleConnectionProblem(e, timestamp);
    }

    protected synchronized void handleConnectionProblem(Exception e, int timestamp) {
        if (this.connectionLostCause == null && this.reconnectAttemptCount == timestamp) {
            try {
                this.healthCheckBuilder.get().setAction(() -> this.tryRecovery()).addFatalCondition(ex -> !this.isConnectionProblemException((Throwable)ex)).build().run();
            }
            catch (Exception mostRecentHealthCheckException) {
                this.connectionLostCause = mostRecentHealthCheckException;
            }
            ++this.reconnectAttemptCount;
        }
        if (this.connectionLostCause != null) {
            throw new ConnectionLostException("connection lost", this.connectionLostCause);
        }
        throw new ConnectionReestablishedException("connection re-established", e);
    }

    @Override
    public QueryExecutionBuilder newQuery() {
        return this.activeDelegate.newQuery();
    }

    public class QueryExecutionWithReconnect
    extends QueryExecutionWrapperBase<QueryExecution> {
        public QueryExecutionWithReconnect(QueryExecution decoratee) {
            super(decoratee);
        }

        @Override
        protected void beforeExec() {
            super.beforeExec();
            SparqlQueryConnectionWithReconnect.this.checkForConnectionLoss();
        }

        @Override
        protected void onException(Exception e) {
            int timestamp = SparqlQueryConnectionWithReconnect.this.getReconnectAttemptCount();
            SparqlQueryConnectionWithReconnect.this.testForConnectionProblem(e, timestamp);
        }
    }
}

