/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.query;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalWrapper;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.TransactionalNull;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.system.Txn;

public interface LinkSparqlQueryBase
extends TransactionalWrapper,
LinkSparqlQuery {
    public static LinkSparqlQuery of(final Supplier<QueryExecBuilder> queryExecBuilderFactory) {
        return new LinkSparqlQueryBase(){

            public QueryExecBuilder newQuery() {
                QueryExecBuilder result = (QueryExecBuilder)queryExecBuilderFactory.get();
                return result;
            }

            public void close() {
            }

            @Override
            public Transactional getDelegate() {
                return new TransactionalNull();
            }
        };
    }

    default public Query parse(String query) {
        return QueryFactory.create((String)query);
    }

    public static <T> T doQueryCompute(Transactional transactional, Supplier<QueryExec> qeSupp, Function<QueryExec, T> computation) {
        Object result = Txn.calculateRead((Transactional)transactional, () -> {
            try (QueryExec qExec = (QueryExec)qeSupp.get();){
                Object tmp;
                Object r = tmp = computation.apply(qExec);
                return r;
            }
        });
        return (T)result;
    }

    public static void doQueryRowSet(Transactional transactional, Supplier<QueryExec> qeSupp, Consumer<RowSet> resultSetAction) {
        Txn.executeRead((Transactional)transactional, () -> {
            try (QueryExec qExec = (QueryExec)qeSupp.get();){
                RowSet rs = qExec.select();
                resultSetAction.accept(rs);
            }
        });
    }

    default public void queryRowSet(String query, Consumer<RowSet> resultSetAction) {
        LinkSparqlQueryBase.doQueryRowSet(this, () -> this.query(query), resultSetAction);
    }

    default public void queryRowSet(Query query, Consumer<RowSet> resultSetAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        LinkSparqlQueryBase.doQueryRowSet(this, () -> this.query(query), resultSetAction);
    }

    default public void querySelect(String query, Consumer<Binding> rowAction) {
        LinkSparqlQueryBase.doQueryRowSet(this, () -> this.query(query), rs -> rs.forEachRemaining(rowAction));
    }

    default public void querySelect(Query query, Consumer<Binding> rowAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        LinkSparqlQueryBase.doQueryRowSet(this, () -> this.query(query), rs -> rs.forEachRemaining(rowAction));
    }

    default public Graph queryConstruct(String query) {
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::construct);
    }

    default public Graph queryConstruct(Query query) {
        if (!query.isConstructType()) {
            throw new JenaConnectionException("Query is not a CONSTRUCT query");
        }
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::construct);
    }

    default public Graph queryDescribe(String query) {
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::describe);
    }

    default public Graph queryDescribe(Query query) {
        if (!query.isDescribeType()) {
            throw new JenaConnectionException("Query is not a DESCRIBE query");
        }
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::describe);
    }

    default public boolean queryAsk(String query) {
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::ask);
    }

    default public boolean queryAsk(Query query) {
        if (!query.isAskType()) {
            throw new JenaConnectionException("Query is not a ASK query");
        }
        return LinkSparqlQueryBase.doQueryCompute(this, () -> this.query(query), QueryExec::ask);
    }

    default public QueryExec query(Query query) {
        return this.newQuery().query(query).build();
    }

    default public QueryExec query(String queryString) {
        return this.newQuery().query(queryString).build();
    }
}

