/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.exec.query;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.aksw.commons.collections.SetUtils;
import org.aksw.commons.util.closeable.AutoCloseableBase;
import org.aksw.jenax.arq.util.quad.QuadPatternUtils;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecBaseIterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryCancelledException;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Substitute;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.modify.TemplateLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.PatternVars;
import org.apache.jena.sparql.syntax.Template;
import org.apache.jena.sparql.util.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryExecBaseSelect
extends AutoCloseableBase
implements QueryExecBaseIterator {
    private static final Logger logger = LoggerFactory.getLogger(QueryExecBaseSelect.class);
    protected Query query;
    protected boolean rawTuples;
    protected volatile QueryExec activeQueryExec;
    protected volatile boolean isCancelled;

    public QueryExecBaseSelect(Query query) {
        this(query, false);
    }

    public QueryExecBaseSelect(Query query, boolean rawTuples) {
        this.query = query;
        this.rawTuples = rawTuples;
    }

    protected abstract QueryExec doSelect(Query var1);

    public DatasetGraph getDataset() {
        return this.activeQueryExec == null ? null : this.activeQueryExec.getDataset();
    }

    public Context getContext() {
        return this.activeQueryExec == null ? null : this.activeQueryExec.getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort() {
        if (!this.isCancelled) {
            QueryExecBaseSelect queryExecBaseSelect = this;
            synchronized (queryExecBaseSelect) {
                if (!this.isCancelled) {
                    this.isCancelled = true;
                    if (this.activeQueryExec != null) {
                        this.activeQueryExec.abort();
                    }
                }
            }
        }
    }

    protected void closeActual() throws Exception {
        if (this.activeQueryExec != null) {
            this.activeQueryExec.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setActiveQueryExec(QueryExec queryExec) {
        QueryExecBaseSelect queryExecBaseSelect = this;
        synchronized (queryExecBaseSelect) {
            if (this.activeQueryExec != null) {
                this.activeQueryExec.close();
            }
            this.activeQueryExec = queryExec;
            if (this.activeQueryExec != null) {
                if (this.isCancelled) {
                    this.activeQueryExec.abort();
                }
                if (this.isClosed) {
                    this.activeQueryExec.close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RowSet internalSelect(Query selectQuery) {
        QueryExec tmp;
        QueryExecBaseSelect queryExecBaseSelect = this;
        synchronized (queryExecBaseSelect) {
            this.ensureOpen();
            if (this.activeQueryExec != null) {
                throw new RuntimeException("Query execution has already been started");
            }
            if (this.isCancelled) {
                throw new QueryCancelledException();
            }
            tmp = this.doSelect(selectQuery);
            this.setActiveQueryExec(tmp);
        }
        return tmp.select();
    }

    public static Query adjust(Query query) {
        Template template = query.getConstructTemplate();
        Set projectVars = QuadPatternUtils.getVarsMentioned((Iterable)template.getQuads());
        Query clone = query.cloneQuery();
        clone.setQuerySelectType();
        clone.getProject().clear();
        if (projectVars.isEmpty()) {
            Set patternVars = SetUtils.asSet((Iterable)PatternVars.vars((Element)query.getQueryPattern()));
            if (patternVars.isEmpty()) {
                clone.setQueryResultStar(true);
            } else {
                Var v = (Var)patternVars.iterator().next();
                clone.setQueryResultStar(false);
                clone.getProject().add(v);
            }
        } else {
            clone.setQueryResultStar(false);
            clone.addProjectVars((Collection)projectVars);
        }
        return clone;
    }

    public boolean ask() {
        if (!this.query.isAskType()) {
            throw new RuntimeException("ASK query expected. Got: [" + this.query.toString() + "]");
        }
        Query selectQuery = QueryUtils.elementToQuery((Element)this.query.getQueryPattern());
        selectQuery.setLimit(1L);
        RowSet rs = this.internalSelect(selectQuery);
        long rowCount = 0L;
        while (rs.hasNext()) {
            rs.next();
            ++rowCount;
        }
        if (rowCount > 1L) {
            logger.warn("Received " + rowCount + " rows for the query [" + this.query.toString() + "]");
        }
        return rowCount > 0L;
    }

    public Iterator<Quad> constructQuads() {
        if (!this.query.isConstructType()) {
            throw new RuntimeException("CONSTRUCT query expected. Got: [" + this.query.toString() + "]");
        }
        Template template = this.query.getConstructTemplate();
        Query clone = QueryExecBaseSelect.adjust(this.query);
        RowSet rs = this.internalSelect(clone);
        Iterator result = this.rawTuples ? Iter.flatMap((Iterator)rs, b -> Iter.map(template.getQuads().iterator(), q -> Substitute.substitute((Quad)q, (Binding)b))) : TemplateLib.calcQuads((List)template.getQuads(), (Iterator)rs);
        return result;
    }

    public Iterator<Triple> constructTriples() {
        if (!this.query.isConstructType()) {
            throw new RuntimeException("CONSTRUCT query expected. Got: [" + this.query.toString() + "]");
        }
        Template template = this.query.getConstructTemplate();
        Query clone = QueryExecBaseSelect.adjust(this.query);
        RowSet rs = this.internalSelect(clone);
        Iterator result = this.rawTuples ? Iter.flatMap((Iterator)rs, b -> Iter.map(template.getTriples().iterator(), t -> Substitute.substitute((Triple)t, (Binding)b))) : TemplateLib.calcTriples((List)template.getTriples(), (Iterator)rs);
        return result;
    }

    public RowSet select() {
        if (this.query != null && !this.query.isSelectType()) {
            throw new RuntimeException("SELECT query expected. Got: [" + this.query.toString() + "]");
        }
        return this.internalSelect(this.query);
    }

    public Query getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.query == null ? null : this.query.toString();
    }

    public Iterator<JsonObject> execJsonItems() {
        throw new UnsupportedOperationException();
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public Iterator<Triple> describeTriples() {
        throw new UnsupportedOperationException("Method not migrated yet");
    }
}

