/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.creator;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.creator.FileSet;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileSetOverPathBase
implements FileSet {
    private static final Logger logger = LoggerFactory.getLogger(FileSetOverPathBase.class);
    protected Path basePath;

    public FileSetOverPathBase(Path basePath) {
        this.basePath = Objects.requireNonNull(basePath);
        FileSetOverPathBase.safetyCheck(basePath);
    }

    public static void safetyCheck(Path path) {
        Path userPath = FileUtils.getUserDirectory().toPath();
        Path absPath = path.toAbsolutePath();
        if (absPath.getParent() == null) {
            throw new IllegalArgumentException("File set must not be the root path. Rejected: " + String.valueOf(absPath));
        }
        if (absPath.equals(userPath)) {
            throw new IllegalArgumentException("File set must not be the home directory. Rejected: " + String.valueOf(absPath));
        }
    }

    public Path getBasePath() {
        return this.basePath;
    }

    @Override
    public void delete() throws IOException {
        List<Path> paths = this.getPaths();
        for (Path path : paths) {
            if (!path.startsWith(this.basePath)) {
                logger.warn("Prevented deletion outside of base folder: " + String.valueOf(path) + " is not a subfolder of " + String.valueOf(this.basePath));
                continue;
            }
            Files.delete(path);
        }
    }

    public String toString() {
        Object sizeStr;
        try {
            sizeStr = Long.toString(this.byteSize());
        }
        catch (Throwable e) {
            sizeStr = "(failed to compute size: " + String.valueOf(e) + ")";
        }
        List<Path> paths = null;
        Object errorStr = "";
        try {
            paths = this.getPaths();
        }
        catch (Throwable t) {
            errorStr = ", error: " + String.valueOf(t);
        }
        if (paths == null) {
            paths = List.of();
        }
        List<Path> relPaths = paths.stream().map(this.basePath::relativize).toList();
        return paths.size() + " files, total logical size " + (String)sizeStr + " bytes, location " + String.valueOf(this.basePath) + ", files " + String.valueOf(relPaths) + (String)errorStr;
    }
}

