/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.detector;

import java.util.Objects;
import org.aksw.commons.util.exception.ExceptionUtilsAksw;
import org.aksw.jenax.arq.util.binding.TableUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.polyfill.detector.Condition;
import org.aksw.jenax.stmt.core.SparqlStmtQuery;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.algebra.Table;

public class ConditionQuery
implements Condition {
    protected SparqlStmtQuery query;
    protected boolean matchOnNonEmptyResult;

    public ConditionQuery(SparqlStmtQuery query, boolean matchOnNonEmptyResult) {
        this.query = Objects.requireNonNull(query);
        this.matchOnNonEmptyResult = matchOnNonEmptyResult;
        if (!this.query.isParsed()) {
            throw new RuntimeException("Non-parsed queries not supported yet");
        }
    }

    @Override
    public boolean test(RDFDataSource dataSource) {
        boolean result;
        try (RDFConnection conn = dataSource.getConnection();
             QueryExecution qe = conn.query(this.query.getQuery());){
            ResultSet rs = qe.execSelect();
            Table table = TableUtils.createTable((ResultSet)rs);
            result = this.matchOnNonEmptyResult ? !table.isEmpty() : false;
        }
        catch (Exception e) {
            boolean isConnectionProblem = this.isConnectionProblemException(e);
            if (isConnectionProblem) {
                e.addSuppressed(new RuntimeException("Connection problem detected", e));
                throw e;
            }
            result = !this.matchOnNonEmptyResult;
        }
        return result;
    }

    protected boolean isConnectionProblemException(Throwable t) {
        return ExceptionUtilsAksw.isConnectionRefusedException((Throwable)t) || ExceptionUtilsAksw.isUnknownHostException((Throwable)t);
    }
}

