/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.common;

import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderWrapperBase;
import org.aksw.jenax.dataaccess.sparql.common.WorkerThreadBase;
import org.aksw.jenax.dataaccess.sparql.exec.update.UpdateExecWrapperBase;
import org.aksw.jenax.dataaccess.sparql.link.query.IteratorDelegateWithWorkerThread;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.Syntax;
import org.apache.jena.query.TxnType;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.exec.UpdateExec;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;
import org.apache.jena.update.UpdateRequest;

public class RDFLinkWrapperWithWorkerThread
extends WorkerThreadBase
implements RDFLink {
    protected RDFLink delegate;

    public RDFLinkWrapperWithWorkerThread(RDFLink delegate) {
        this(delegate, null);
    }

    public RDFLinkWrapperWithWorkerThread(RDFLink delegate, ExecutorService executorService) {
        super(executorService);
        this.delegate = delegate;
    }

    public static RDFLink wrap(RDFLink delegate) {
        return new RDFLinkWrapperWithWorkerThread(delegate);
    }

    public RDFLink getDelegate() {
        return this.delegate;
    }

    public void begin(TxnType type) {
        this.submit(() -> this.getDelegate().begin(type));
    }

    public void begin(ReadWrite readWrite) {
        this.submit(() -> this.getDelegate().begin(readWrite));
    }

    public boolean promote(Transactional.Promote mode) {
        return this.submit(() -> this.getDelegate().promote(mode));
    }

    public void commit() {
        this.submit(() -> this.getDelegate().commit());
    }

    public void abort() {
        this.submit(() -> this.getDelegate().abort());
    }

    public void end() {
        this.submit(() -> this.getDelegate().end());
    }

    public ReadWrite transactionMode() {
        return this.submit(() -> this.getDelegate().transactionMode());
    }

    public TxnType transactionType() {
        return this.submit(() -> this.getDelegate().transactionType());
    }

    public boolean isInTransaction() {
        return this.submit(() -> this.getDelegate().isInTransaction());
    }

    public DatasetGraph getDataset() {
        return this.submit(() -> this.getDelegate().getDataset());
    }

    public QueryExec query(Query query) {
        return this.submit(() -> new QueryExecWrapper(this.getDelegate().query(query)));
    }

    public QueryExec query(String queryString) {
        return this.submit(() -> new QueryExecWrapper(this.getDelegate().query(queryString)));
    }

    public QueryExecBuilder newQuery() {
        return this.submit(() -> this.getDelegate().newQuery());
    }

    public UpdateExecBuilder newUpdate() {
        return new UpdateExecBuilderWrapperBase(this.getDelegate().newUpdate()){

            @Override
            public UpdateExec build() {
                UpdateExec tmp = RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.build());
                return new UpdateExecWrapper(tmp);
            }
        };
    }

    public void update(UpdateRequest update) {
        this.submit(() -> this.getDelegate().update(update));
    }

    public Graph get() {
        return this.submit(() -> this.getDelegate().get());
    }

    public Graph get(Node graphName) {
        return this.submit(() -> this.getDelegate().get(graphName));
    }

    public void load(String file) {
        this.submit(() -> this.getDelegate().load(file));
    }

    public void load(Node graphName, String file) {
        this.submit(() -> this.getDelegate().load(graphName, file));
    }

    public void load(Graph graph) {
        this.submit(() -> this.getDelegate().load(graph));
    }

    public void load(Node graphName, Graph graph) {
        this.submit(() -> this.getDelegate().load(graphName, graph));
    }

    public void put(String file) {
        this.submit(() -> this.getDelegate().put(file));
    }

    public void put(Node graphName, String file) {
        this.submit(() -> this.getDelegate().put(graphName, file));
    }

    public void put(Graph graph) {
        this.submit(() -> this.getDelegate().put(graph));
    }

    public void put(Node graphName, Graph graph) {
        this.submit(() -> this.getDelegate().put(graphName, graph));
    }

    public void delete(Node graphName) {
        this.submit(() -> this.getDelegate().delete(graphName));
    }

    public void delete() {
        this.submit(() -> this.getDelegate().delete());
    }

    public void loadDataset(String file) {
        this.submit(() -> this.getDelegate().loadDataset(file));
    }

    public void loadDataset(DatasetGraph dataset) {
        this.submit(() -> this.getDelegate().loadDataset(dataset));
    }

    public void putDataset(String file) {
        this.submit(() -> this.getDelegate().putDataset(file));
    }

    public void putDataset(DatasetGraph dataset) {
        this.submit(() -> this.getDelegate().putDataset(dataset));
    }

    public void clearDataset() {
        this.submit(() -> this.getDelegate().clearDataset());
    }

    public boolean isClosed() {
        return this.submit(() -> this.getDelegate().isClosed());
    }

    public void close() {
        if (this.es == null || !this.es.isShutdown()) {
            this.submit(() -> this.getDelegate().close());
            this.es.shutdownNow();
        }
    }

    class QueryExecWrapper
    implements QueryExec {
        protected QueryExec delegate;

        public QueryExecWrapper(QueryExec delegate) {
            this.delegate = delegate;
        }

        public QueryExec getDelegate() {
            return this.delegate;
        }

        public DatasetGraph getDataset() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().getDataset());
        }

        public Context getContext() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().getContext());
        }

        public Query getQuery() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().getQuery());
        }

        public String getQueryString() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().getQueryString());
        }

        public RowSet select() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> new RowSetDelegate(this.getDelegate().select(), RDFLinkWrapperWithWorkerThread.this.es));
        }

        public Graph construct(Graph graph) {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().construct(graph));
        }

        public Iterator<Triple> constructTriples() {
            return (Iterator)((Object)RDFLinkWrapperWithWorkerThread.this.submit(() -> new IteratorDelegateWithWorkerThread(this.getDelegate().constructTriples(), RDFLinkWrapperWithWorkerThread.this.es)));
        }

        public Iterator<Quad> constructQuads() {
            return (Iterator)((Object)RDFLinkWrapperWithWorkerThread.this.submit(() -> new IteratorDelegateWithWorkerThread(this.getDelegate().constructQuads(), RDFLinkWrapperWithWorkerThread.this.es)));
        }

        public DatasetGraph constructDataset(DatasetGraph dataset) {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().constructDataset(dataset));
        }

        public Graph describe(Graph graph) {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().describe(graph));
        }

        public Iterator<Triple> describeTriples() {
            return (Iterator)((Object)RDFLinkWrapperWithWorkerThread.this.submit(() -> new IteratorDelegateWithWorkerThread(this.getDelegate().describeTriples(), RDFLinkWrapperWithWorkerThread.this.es)));
        }

        public boolean ask() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().ask());
        }

        public JsonArray execJson() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().execJson());
        }

        public Iterator<JsonObject> execJsonItems() {
            return (Iterator)((Object)RDFLinkWrapperWithWorkerThread.this.submit(() -> new IteratorDelegateWithWorkerThread(this.getDelegate().execJsonItems(), RDFLinkWrapperWithWorkerThread.this.es)));
        }

        public void abort() {
            this.getDelegate().abort();
        }

        public void close() {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().close());
        }

        public boolean isClosed() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.getDelegate().isClosed());
        }
    }

    static class RowSetDelegate
    extends IteratorDelegateWithWorkerThread<Binding, RowSet>
    implements RowSet {
        protected RowSet delegate;

        public RowSetDelegate(RowSet delegate, ExecutorService es) {
            super(delegate, es);
        }

        @Override
        protected Binding copy(Binding item) {
            return BindingFactory.copy((Binding)item);
        }

        public List<Var> getResultVars() {
            return this.helper.submit(() -> ((RowSet)this.getDelegate()).getResultVars());
        }

        public long getRowNumber() {
            return this.helper.submit(() -> ((RowSet)this.getDelegate()).getRowNumber());
        }
    }

    class QueryExecBuilderWrapper
    implements QueryExecBuilder {
        protected QueryExecBuilder delegate;

        public QueryExecBuilderWrapper(QueryExecBuilder delegate) {
            this.delegate = delegate;
        }

        public QueryExecMod timeout(long timeout) {
            return this.timeout(timeout, TimeUnit.MILLISECONDS);
        }

        public QueryExecMod initialTimeout(long timeout, TimeUnit timeUnit) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.initialTimeout(timeout, timeUnit));
            return this;
        }

        public QueryExecMod overallTimeout(long timeout, TimeUnit timeUnit) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.overallTimeout(timeout, timeUnit));
            return this;
        }

        public Context getContext() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.getContext());
        }

        public QueryExecBuilder query(Query query) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.query(query));
            return this;
        }

        public QueryExecBuilder query(String queryString) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.query(queryString));
            return this;
        }

        public QueryExecBuilder query(String queryString, Syntax syntax) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.query(queryString, syntax));
            return this;
        }

        public QueryExecBuilder parseCheck(boolean parseCheck) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.parseCheck(parseCheck));
            return this;
        }

        public QueryExecBuilder set(Symbol symbol, Object value) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.set(symbol, value));
            return this;
        }

        public QueryExecBuilder set(Symbol symbol, boolean value) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.set(symbol, value));
            return this;
        }

        public QueryExecBuilder context(Context context) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.context(context));
            return this;
        }

        public QueryExecBuilder substitution(Binding binding) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.substitution(binding));
            return this;
        }

        public QueryExecBuilder substitution(Var var, Node value) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.substitution(var, value));
            return this;
        }

        public QueryExecBuilder timeout(long value, TimeUnit timeUnit) {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> this.delegate.timeout(value, timeUnit));
            return this;
        }

        public QueryExec build() {
            return RDFLinkWrapperWithWorkerThread.this.submit(() -> new QueryExecWrapper(this.delegate.build()));
        }
    }

    class UpdateExecWrapper
    extends UpdateExecWrapperBase<UpdateExec> {
        public UpdateExecWrapper(UpdateExec delegate) {
            super(delegate);
        }

        @Override
        public void execute() {
            RDFLinkWrapperWithWorkerThread.this.submit(() -> ((UpdateExec)this.delegate).execute());
        }
    }
}

