/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.datasource;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.MultiRequestBuilder;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryBase;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkModular;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.syntax.Element;

public class RdfDataSourceMulti
implements RDFDataSource {
    protected Map<Node, RDFDataSource> dataSources = new LinkedHashMap<Node, RDFDataSource>();

    public static Builder newBuilder() {
        return new Builder();
    }

    public RdfDataSourceMulti() {
    }

    protected RdfDataSourceMulti(Map<Node, RDFDataSource> dataSources) {
        this.dataSources = dataSources;
    }

    public Map<Node, RDFDataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public RDFConnection getConnection() {
        return RDFConnectionAdapter.adapt((RDFLink)new RDFLinkModular((LinkSparqlQuery)new LinkSparqlQueryBase(){

            public QueryExecBuilder newQuery() {
                return new QueryExecBuilderCustomBase<QueryExecBuilder>(){

                    @Override
                    public QueryExec build() {
                        Query q = this.getParsedQueryCopy();
                        Element elt = q.getQueryPattern();
                        MultiRequestBuilder builder = new MultiRequestBuilder();
                        RdfDataSourceMulti.this.dataSources.forEach((node, dataSource) -> builder.add((Node)node, elt, (RDFDataSource)dataSource, null));
                        QueryExec r = builder.build(e -> {
                            q.setQueryPattern(e);
                            System.err.println("Built query: " + String.valueOf(q));
                            return q;
                        });
                        return r;
                    }
                };
            }

            public void close() {
            }

            @Override
            public Transactional getDelegate() {
                return null;
            }
        }, null, null));
    }

    public static void main(String[] args) {
        RdfDataSourceMulti dsRaw;
        RDFDataSource ds1 = () -> RDFConnectionRemote.newBuilder().destination("http://maven.aksw.org/sparql").build();
        RDFDataSource ds2 = () -> RDFConnectionRemote.newBuilder().destination("http://linkedgeodata.org/sparql").build();
        RDFDataSource ds3 = () -> RDFConnectionRemote.newBuilder().destination("https://staging.databus.dbpedia.org/repo/sparql").build();
        RdfDataSourceMulti ds = dsRaw = RdfDataSourceMulti.newBuilder().add("http://maven.aksw.org/sparql", ds1).add("http://linkedgeodata.org/sparql", ds2).add("urn://p.p.p.org/sparql", ds3).build();
        String queryStrX = "    SELECT * {\n      { SELECT ?t (COUNT(*) AS ?c) {\n        GRAPH ?g {\n          ?s a ?t .\n          FILTER(?t IN (\n            <http://www.w3.org/2000/01/rdf-schema#Class>,\n            <http://www.w3.org/2002/07/owl#Class>,\n            <http://www.w3.org/ns/dcat#Dataset>))\n          ?s ?p ?o\n         }\n       } GROUP BY ?t }\n       BIND(<env://SOURCE> AS ?source)\n     }\n     ORDER BY ?source ?t\n";
        String queryStr = "SELECT ?source ?t (COUNT(*) AS ?c) {\n  GRAPH ?g {\n    ?s a ?t .\n    FILTER(?t IN (\n      <http://www.w3.org/2000/01/rdf-schema#Class>,\n      <http://www.w3.org/2002/07/owl#Class>,\n      <http://www.w3.org/ns/dcat#Dataset>))\n    ?s ?p ?o\n   }\n   BIND(<env://SOURCE> AS ?source)\n  } GROUP BY ?source ?t\n ORDER BY ?source ?t\n";
        try (QueryExecution qe = ds.asQef().createQueryExecution(queryStr);){
            System.out.println(ResultSetFormatter.asText((ResultSet)qe.execSelect()));
        }
    }

    public static class Builder {
        protected Map<Node, RDFDataSource> dataSources = new LinkedHashMap<Node, RDFDataSource>();

        public Builder add(RDFDataSource dataSource) {
            this.add(NodeFactory.createURI((String)("urn:service:" + System.identityHashCode(dataSource))), dataSource);
            return this;
        }

        public Builder add(String dataSourceIri, RDFDataSource dataSource) {
            this.add(NodeFactory.createURI((String)dataSourceIri), dataSource);
            return this;
        }

        public Builder add(Node dataSourceNode, RDFDataSource dataSource) {
            this.dataSources.put(dataSourceNode, dataSource);
            return this;
        }

        public RdfDataSourceMulti build() {
            LinkedHashMap<Node, RDFDataSource> map = new LinkedHashMap<Node, RDFDataSource>(this.dataSources);
            return new RdfDataSourceMulti(map);
        }
    }
}

