/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.datasource;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.aksw.jenax.arq.util.binding.QueryIterOverQueryExec;
import org.aksw.jenax.arq.util.node.NodeUtils;
import org.aksw.jenax.arq.util.syntax.ElementUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.MultiRequestElt;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphFactory;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecAdapter;
import org.apache.jena.sparql.service.ServiceExecutorRegistry;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.util.Context;

class MultiRequestBuilder {
    protected List<MultiRequestElt> members = new ArrayList<MultiRequestElt>();

    MultiRequestBuilder() {
    }

    public static Node allocate(Node base, Predicate<Node> alreadySeen) {
        String lex = NodeUtils.getUnquotedForm((Node)base);
        Node result = null;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String str = lex + "_" + i;
            Node node = result = base.isURI() ? NodeFactory.createURI((String)str) : NodeFactory.createLiteralString((String)str);
            if (!alreadySeen.test(result)) break;
        }
        return result;
    }

    public void add(Node serviceNode, Element element, RDFDataSource dataSource, Binding binding) {
        this.members.add(new MultiRequestElt(serviceNode, element, dataSource, binding));
    }

    public QueryExec build(Function<Element, Query> eltToQuery) {
        HashSet<Node> seenDataSourceNodes = new HashSet<Node>();
        IdentityHashMap<Object, Node> sourceToNode = new IdentityHashMap<Object, Node>();
        for (int i = 0; i < this.members.size(); ++i) {
            Node sourceNode;
            MultiRequestElt member = this.members.get(i);
            RDFDataSource dataSource = member.dataSource();
            if (dataSource == null || (sourceNode = (Node)sourceToNode.get(dataSource)) != null) continue;
            Node serviceNode = member.serviceNode();
            if (serviceNode == null) {
                serviceNode = NodeFactory.createURI((String)"urn:service:id");
            }
            sourceNode = MultiRequestBuilder.allocate(serviceNode, seenDataSourceNodes::contains);
            sourceToNode.put(dataSource, sourceNode);
            seenDataSourceNodes.add(sourceNode);
        }
        Map<Node, RDFDataSource> nodeToSource = sourceToNode.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
        ArrayList<ElementService> elts = new ArrayList<ElementService>();
        for (MultiRequestElt member : this.members) {
            Binding b = member.binding();
            Element elt = member.element();
            if (b != null) {
                ElementGroup group = new ElementGroup();
                ElementUtils.copyElements((ElementGroup)group, (Element)elt);
                ElementUtils.addBinding((ElementGroup)group, (Binding)b);
                elt = group;
            }
            Node dataSourceServiceNode = sourceToNode.getOrDefault(member.dataSource(), member.serviceNode());
            Node memberServiceNode = Optional.ofNullable(member.serviceNode()).orElse(dataSourceServiceNode);
            Node SOURCE = NodeFactory.createURI((String)"env://SOURCE");
            elt = ElementUtils.applyNodeTransform((Element)elt, node -> SOURCE.equals(node) ? memberServiceNode : node);
            elts.add(new ElementService(dataSourceServiceNode, elt, false));
        }
        Element union = ElementUtils.unionIfNeeded(elts);
        Query query = eltToQuery.apply(union);
        ServiceExecutorRegistry reg = ServiceExecutorRegistry.createFrom(null);
        reg.addBulkLink((opService, input, execCxt, chain) -> {
            QueryIterator r;
            Node serviceNode = opService.getService();
            RDFDataSource dataSource = (RDFDataSource)nodeToSource.get(serviceNode);
            if (dataSource != null) {
                Query qq = OpAsQuery.asQuery((Op)opService.getSubOp());
                QueryExec qe = QueryExecAdapter.adapt((QueryExecution)dataSource.asQef().createQueryExecution(qq));
                r = new QueryIterOverQueryExec(execCxt, qe);
            } else {
                r = chain.createExecution(opService, input, execCxt);
            }
            return r;
        });
        DatasetGraph proxyDataset = DatasetGraphFactory.create();
        ServiceExecutorRegistry.set((Context)proxyDataset.getContext(), (ServiceExecutorRegistry)reg);
        return QueryExec.newBuilder().dataset(proxyDataset).query(query).build();
    }
}

