/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import com.google.common.base.StandardSystemProperty;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Map;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineBuilder;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RdfDataEngineBuilderBase;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RDFEngineFactoryLegacyBase
implements RDFEngineFactory {
    private static final Logger logger = LoggerFactory.getLogger(RDFEngineFactoryLegacyBase.class);

    @Override
    public RDFEngineBuilder<?> newEngineBuilder() {
        return new RdfDataEngineBuilderBase(){

            @Override
            public RDFEngine build() throws Exception {
                return RDFEngineFactoryLegacyBase.this.create(this.map);
            }
        };
    }

    @Override
    public abstract RDFEngine create(Map<String, Object> var1) throws Exception;

    public static CloseablePath setupPath(String tempDirPrefix, RdfDataSourceSpecBasic spec) throws IOException {
        return RDFEngineFactoryLegacyBase.setupPath(spec.getLocation(), spec.getLocationContext(), spec.getTempDir(), tempDirPrefix, spec.isAutoDeleteIfCreated());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CloseablePath setupPath(String location, String locationContext, String tempDir, String tempDirPrefix, boolean isAutoDeleteIfCreated) throws IOException {
        CloseablePath info;
        CloseablePath fsInfo = RDFEngineFactoryLegacyBase.resolveFileSystemAndPath(locationContext, location);
        Path dbPath = fsInfo.path();
        Closeable fsCloseAction = fsInfo.closeable();
        try {
            info = RDFEngineFactoryLegacyBase.createFolder(dbPath, tempDir, tempDirPrefix, isAutoDeleteIfCreated);
        }
        catch (Throwable e) {
            try {
                fsCloseAction.close();
            }
            finally {
                throw new RuntimeException(e);
            }
        }
        Path finalDbPath = info.path();
        Closeable folderDeleteAction = info.closeable();
        Closeable partialCloseAction = () -> {
            try {
                folderDeleteAction.close();
            }
            finally {
                fsCloseAction.close();
            }
        };
        return new CloseablePath(finalDbPath, partialCloseAction, info.deleteOnClose());
    }

    public static CloseablePath createFolder(Path dbPath, String tempDir, String tempDirPrefix, boolean isAutoDeleteIfCreated) throws IOException {
        CloseablePath result;
        boolean createdDbDir = false;
        if (dbPath == null) {
            String tmpDirStr = tempDir;
            if (tmpDirStr == null) {
                tmpDirStr = StandardSystemProperty.JAVA_IO_TMPDIR.value();
            }
            if (tmpDirStr == null) {
                throw new IllegalStateException("Temp dir neither specified nor obtainable from java.io.tmpdir");
            }
            Path tmpDir = Path.of(tmpDirStr, new String[0]);
            dbPath = Files.createTempDirectory(tmpDir, tempDirPrefix, new FileAttribute[0]).toAbsolutePath();
            createdDbDir = true;
        } else if (!Files.exists(dbPath = dbPath.toAbsolutePath(), new LinkOption[0])) {
            Files.createDirectory(dbPath, new FileAttribute[0]);
            createdDbDir = true;
        }
        Path finalDbPath = dbPath;
        if (createdDbDir) {
            if (Boolean.TRUE.equals(isAutoDeleteIfCreated)) {
                logger.info("Created new directory (its content will deleted when done): " + String.valueOf(finalDbPath));
                deleteAction = () -> {
                    logger.info("Deleting created directory: " + String.valueOf(finalDbPath));
                    Files.deleteIfExists(finalDbPath);
                };
                result = new CloseablePath(finalDbPath, deleteAction, true);
            } else {
                logger.info("Created new directory (will be kept after done): " + String.valueOf(finalDbPath));
                deleteAction = () -> {};
                result = new CloseablePath(finalDbPath, deleteAction, false);
            }
        } else {
            logger.info("Folder already existed - delete action disabled: " + String.valueOf(finalDbPath));
            deleteAction = () -> {};
            result = new CloseablePath(finalDbPath, deleteAction, false);
        }
        return result;
    }

    public static CloseablePath resolveFileSystemAndPath(String fsUri, String pathStr) throws IOException {
        Closeable fsCloseActionTmp;
        FileSystem fs;
        Path dbPath = null;
        if (fsUri != null && !fsUri.isBlank()) {
            fs = FileSystems.newFileSystem(URI.create(fsUri), Collections.emptyMap());
            fsCloseActionTmp = () -> fs.close();
        } else {
            fs = FileSystems.getDefault();
            fsCloseActionTmp = () -> {};
        }
        Closeable closeAction = fsCloseActionTmp;
        try {
            if (pathStr != null && !pathStr.isBlank()) {
                dbPath = fs.getPath(pathStr, new String[0]).toAbsolutePath();
            }
        }
        catch (Exception e) {
            try {
                closeAction.close();
            }
            catch (Exception e2) {
                throw new RuntimeException(e2);
            }
            throw new RuntimeException(e);
        }
        return new CloseablePath(dbPath, closeAction, false);
    }

    public record CloseablePath(Path path, Closeable closeable, boolean deleteOnClose) {
    }
}

