/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngines;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RdfDataEngineFromDataset;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilder;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilderOverLinkSupplier;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryBase;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.rdflink.RDFLinkModular;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;

public class RDFDataEngines {
    public static RDFEngine adapt(QueryExecutionFactory qef) {
        RDFLinkSourceOverQueryExecutionFactory linkSource = new RDFLinkSourceOverQueryExecutionFactory(qef);
        return RDFEngines.of(linkSource, qef::close);
    }

    public static RDFEngine of(Model model) {
        return RDFDataEngines.of(DatasetFactory.wrap((Model)model));
    }

    public static RDFEngine of(Dataset dataset) {
        return new RdfDataEngineFromDataset(dataset.asDatasetGraph(), true);
    }

    public static class RDFLinkSourceOverQueryExecutionFactory
    implements RDFLinkSource {
        protected QueryExecutionFactory qef;

        public RDFLinkSourceOverQueryExecutionFactory(QueryExecutionFactory qef) {
            this.qef = qef;
        }

        @Override
        public RDFLinkBuilder<?> newLinkBuilder() {
            return new RDFLinkBuilderOverLinkSupplier(() -> {
                LinkSparqlQuery queryLink = LinkSparqlQueryBase.of(() -> new QueryExecBuilderCustomBase<QueryExecBuilder>(){

                    @Override
                    public QueryExec build() {
                        String str = this.getQueryString();
                        QueryExecution qe = str != null ? qef.createQueryExecution(str) : qef.createQueryExecution(this.getParsedQuery());
                        return QueryExec.adapt((QueryExecution)qe);
                    }
                });
                return new RDFLinkModular(queryLink, null, null);
            });
        }
    }
}

