/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.connection.query;

import java.util.function.Consumer;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalWrapper;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.JenaConnectionException;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.system.Txn;

public interface SparqlQueryConnectionTmp
extends TransactionalWrapper,
SparqlQueryConnection {
    default public Query parse(String query) {
        return QueryFactory.create((String)query);
    }

    default public void queryResultSet(String query, Consumer<ResultSet> resultSetAction) {
        this.queryResultSet(this.parse(query), resultSetAction);
    }

    default public void queryResultSet(Query query, Consumer<ResultSet> resultSetAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                ResultSet rs = qExec.execSelect();
                resultSetAction.accept(rs);
            }
        });
    }

    default public void querySelect(String query, Consumer<QuerySolution> rowAction) {
        this.querySelect(this.parse(query), rowAction);
    }

    default public void querySelect(Query query, Consumer<QuerySolution> rowAction) {
        if (!query.isSelectType()) {
            throw new JenaConnectionException("Query is not a SELECT query");
        }
        Txn.executeRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                qExec.execSelect().forEachRemaining(rowAction);
            }
        });
    }

    default public Model queryConstruct(String query) {
        return this.queryConstruct(this.parse(query));
    }

    default public Model queryConstruct(Query query) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Model model = qExec.execConstruct();
                return model;
            }
        });
    }

    default public Model queryDescribe(String query) {
        return this.queryDescribe(this.parse(query));
    }

    default public Model queryDescribe(Query query) {
        return (Model)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Model model = qExec.execDescribe();
                return model;
            }
        });
    }

    default public boolean queryAsk(String query) {
        return this.queryAsk(this.parse(query));
    }

    default public boolean queryAsk(Query query) {
        return (Boolean)Txn.calculateRead((Transactional)this, () -> {
            try (QueryExecution qExec = this.query(query);){
                Boolean bl = qExec.execAsk();
                return bl;
            }
        });
    }

    public QueryExecution query(Query var1);

    default public QueryExecution query(String queryString) {
        return this.query(this.parse(queryString));
    }

    default public QueryExecutionBuilder newQuery() {
        throw new UnsupportedOperationException();
    }
}

