/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.builder.exec.query;

import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecMod;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.ContextAccumulator;

public abstract class QueryExecModCustomBase<T extends QueryExecMod>
implements QueryExecMod {
    protected ContextAccumulator contextAccumulator;
    protected long initialTimeoutValue = -1L;
    protected TimeUnit initialTimeoutUnit;
    protected long overallTimeoutValue = -1L;
    protected TimeUnit overallTimeoutUnit;

    public QueryExecModCustomBase() {
        this(Context::emptyContext);
    }

    public QueryExecModCustomBase(Supplier<Context> baseContextSupplier) {
        this(ContextAccumulator.newBuilder(baseContextSupplier));
    }

    public QueryExecModCustomBase(ContextAccumulator contextAccumulator) {
        this.contextAccumulator = contextAccumulator;
    }

    public QueryExecModCustomBase(QueryExecModCustomBase<?> that) {
        this.contextAccumulator = that.contextAccumulator.clone();
        this.initialTimeoutValue = that.initialTimeoutValue;
        this.initialTimeoutUnit = that.initialTimeoutUnit;
        this.overallTimeoutValue = that.overallTimeoutValue;
        this.overallTimeoutUnit = that.overallTimeoutUnit;
    }

    public TimeUnit getInitialTimeoutUnit() {
        return this.initialTimeoutUnit;
    }

    public long getInitialTimeoutValue() {
        return this.initialTimeoutValue;
    }

    public long getOverallTimeoutValue() {
        return this.overallTimeoutValue;
    }

    public TimeUnit getOverallTimeoutUnit() {
        return this.overallTimeoutUnit;
    }

    protected T self() {
        return (T)this;
    }

    public QueryExecMod timeout(long timeout) {
        this.overallTimeout(timeout, TimeUnit.MILLISECONDS);
        return this.self();
    }

    public T initialTimeout(long timeout, TimeUnit timeUnit) {
        this.initialTimeoutValue = timeout;
        this.initialTimeoutUnit = timeUnit;
        return this.self();
    }

    public T overallTimeout(long timeout, TimeUnit timeUnit) {
        this.overallTimeoutValue = timeout;
        this.overallTimeoutUnit = timeUnit;
        return this.self();
    }

    public Context getContext() {
        return this.contextAccumulator.context();
    }

    public abstract QueryExec build();

    public static void defaultTimeoutsFromContext(QueryExecModCustomBase<?> builder, Context cxt) {
        QueryExecModCustomBase.applyTimeouts(builder, cxt.get(ARQ.queryTimeout));
    }

    public static <T extends QueryExecMod> T overwriteTimeouts(T builder, Object obj) {
        if (obj != null) {
            try {
                if (obj instanceof Number) {
                    long x = ((Number)obj).longValue();
                    builder.overallTimeout(x, TimeUnit.MILLISECONDS);
                } else if (obj instanceof String) {
                    String str = obj.toString();
                    Pair pair = Timeouts.parseTimeoutStr((String)str, (TimeUnit)TimeUnit.MILLISECONDS);
                    if (pair != null) {
                        builder.initialTimeout(((Long)pair.getLeft()).longValue(), TimeUnit.MILLISECONDS);
                        builder.overallTimeout(((Long)pair.getRight()).longValue(), TimeUnit.MILLISECONDS);
                    } else {
                        Log.warn(builder, (String)("Bad timeout string: " + str));
                    }
                } else {
                    Log.warn(builder, (String)("Can't interpret timeout: " + String.valueOf(obj)));
                }
            }
            catch (Exception ex) {
                Log.warn(builder, (String)("Exception setting timeouts (context) from: " + String.valueOf(obj)), (Throwable)ex);
            }
        }
        return builder;
    }

    public static void applyTimeouts(QueryExecModCustomBase<?> builder, Object obj) {
        if (obj == null) {
            return;
        }
        try {
            if (obj instanceof Number) {
                long x = ((Number)obj).longValue();
                if (builder.overallTimeoutValue < 0L) {
                    builder.overallTimeout(x, TimeUnit.MILLISECONDS);
                }
            } else if (obj instanceof String) {
                String str = obj.toString();
                Pair pair = Timeouts.parseTimeoutStr((String)str, (TimeUnit)TimeUnit.MILLISECONDS);
                if (pair == null) {
                    Log.warn(builder, (String)("Bad timeout string: " + str));
                    return;
                }
                if (builder.initialTimeoutValue < 0L) {
                    builder.initialTimeout((Long)pair.getLeft(), TimeUnit.MILLISECONDS);
                }
                if (builder.overallTimeoutValue < 0L) {
                    builder.overallTimeout((Long)pair.getRight(), TimeUnit.MILLISECONDS);
                }
            } else {
                Log.warn(builder, (String)("Can't interpret timeout: " + String.valueOf(obj)));
            }
        }
        catch (Exception ex) {
            Log.warn(builder, (String)("Exception setting timeouts (context) from: " + String.valueOf(obj)), (Throwable)ex);
        }
    }

    public <X extends QueryExecMod> X applySettings(X dst) {
        Context dstCxt;
        Context context;
        if (this.initialTimeoutUnit != null) {
            dst.initialTimeout(this.initialTimeoutValue, this.initialTimeoutUnit);
        }
        if (this.overallTimeoutUnit != null) {
            dst.initialTimeout(this.overallTimeoutValue, this.overallTimeoutUnit);
        }
        if ((context = this.getContext()) != null && (dstCxt = dst.getContext()) != null) {
            dstCxt.putAll(context);
        }
        return dst;
    }
}

