/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.execution.query;

import org.aksw.jenax.dataaccess.sparql.factory.engine.query.QueryEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactoryBackQuery;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;
import org.apache.jena.sparql.util.Context;

public class QueryExecutionFactoryDataset
extends QueryExecutionFactoryBackQuery {
    protected Dataset dataset;
    protected Context context;
    protected QueryEngineFactoryProvider queryEngineFactoryProvider;

    public QueryExecutionFactoryDataset() {
        this(DatasetFactory.create());
    }

    public QueryExecutionFactoryDataset(Dataset dataset) {
        this(dataset, null);
    }

    public QueryExecutionFactoryDataset(Dataset dataset, Context context) {
        this(dataset, context, (arg_0, arg_1, arg_2) -> ((QueryEngineRegistry)QueryEngineRegistry.get()).find(arg_0, arg_1, arg_2));
    }

    public QueryExecutionFactoryDataset(Dataset dataset, Context context, QueryEngineFactoryProvider queryEngineFactoryProvider) {
        this.dataset = dataset;
        this.context = context;
        this.queryEngineFactoryProvider = queryEngineFactoryProvider;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public QueryExecution createQueryExecution(Query query) {
        QueryEngineFactory f;
        query.setResultVars();
        if (this.context == null) {
            this.context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (this.dataset != null) {
            dsg = this.dataset.asDatasetGraph();
        }
        if ((f = this.queryEngineFactoryProvider.find(query, dsg, this.context)) == null) {
            Log.warn(QueryExecutionFactory.class, (String)("Failed to find a QueryEngineFactory for query: " + String.valueOf(query)));
            return null;
        }
        Context cxt = Context.setupContextForDataset((Context)this.context, (DatasetGraph)dsg);
        QueryExecDataset qExec = new QueryExecDataset(query, query.toString(), dsg, cxt, f, Timeouts.Timeout.UNSET, null){};
        QueryExecution result = QueryExecutionAdapter.adapt((QueryExec)qExec);
        return result;
    }

    @Override
    public String getId() {
        return "" + this.dataset.hashCode();
    }

    @Override
    public String getState() {
        return "" + this.dataset.hashCode();
    }
}

