/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.execution.query;

import java.util.concurrent.Callable;
import java.util.function.Supplier;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecSupplier;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecutionAdapter;

@FunctionalInterface
public interface QueryExecutionSupplier {
    public QueryExecution get();

    default public QueryExecSupplier levelDown() {
        return QueryExecSupplier.adapt(this);
    }

    public static QueryExecutionSupplier adapt(QueryExecSupplier lower) {
        return () -> QueryExecutionAdapter.adapt((QueryExec)lower.get());
    }

    public static QueryExecutionSupplier of(Supplier<QueryExecution> supp) {
        return supp::get;
    }

    public static QueryExecutionSupplier of(Callable<QueryExecution> supp) {
        return () -> {
            QueryExecution r;
            try {
                r = (QueryExecution)supp.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return r;
        };
    }
}

