/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.connection.dataset;

import java.util.Arrays;
import java.util.List;
import org.aksw.jenax.dataaccess.sparql.common.MultiplexUtils;
import org.aksw.jenax.dataaccess.sparql.common.TransactionalMultiplex;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFDatasetConnection;

public class RDFDatasetConnectionMultiplex
extends TransactionalMultiplex<RDFDatasetConnection>
implements RDFDatasetConnection {
    public RDFDatasetConnectionMultiplex(RDFDatasetConnection ... delegates) {
        this((List<? extends RDFDatasetConnection>)Arrays.asList(delegates));
    }

    public RDFDatasetConnectionMultiplex(List<? extends RDFDatasetConnection> delegates) {
        super(delegates);
    }

    public Model fetch(String graphName) {
        return ((RDFDatasetConnection)this.delegates.iterator().next()).fetch(graphName);
    }

    public Model fetch() {
        return ((RDFDatasetConnection)this.delegates.iterator().next()).fetch();
    }

    public Dataset fetchDataset() {
        return ((RDFDatasetConnection)this.delegates.iterator().next()).fetchDataset();
    }

    public void load(String graphName, String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.load(graphName, file));
    }

    public void load(String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.load(file));
    }

    public void load(String graphName, Model model) {
        MultiplexUtils.forEach(this.delegates, d -> d.load(graphName, model));
    }

    public void load(Model model) {
        MultiplexUtils.forEach(this.delegates, d -> d.load(model));
    }

    public void put(String graphName, String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.put(graphName, file));
    }

    public void put(String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.put(file));
    }

    public void put(String graphName, Model model) {
        MultiplexUtils.forEach(this.delegates, d -> d.put(graphName, model));
    }

    public void put(Model model) {
        MultiplexUtils.forEach(this.delegates, d -> d.put(model));
    }

    public void delete(String graphName) {
        MultiplexUtils.forEach(this.delegates, d -> d.delete(graphName));
    }

    public void delete() {
        MultiplexUtils.forEach(this.delegates, RDFDatasetConnection::delete);
    }

    public void loadDataset(String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.loadDataset(file));
    }

    public void loadDataset(Dataset dataset) {
        MultiplexUtils.forEach(this.delegates, d -> d.loadDataset(dataset));
    }

    public void putDataset(String file) {
        MultiplexUtils.forEach(this.delegates, d -> d.putDataset(file));
    }

    public void putDataset(Dataset dataset) {
        MultiplexUtils.forEach(this.delegates, d -> d.putDataset(dataset));
    }

    public boolean isClosed() {
        boolean result = ((RDFDatasetConnection)this.delegates.iterator().next()).isClosed();
        return result;
    }

    public void close() {
        MultiplexUtils.forEach(this.delegates, RDFDatasetConnection::close);
    }
}

