/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.aksw.commons.collections.PrefetchIterator;
import org.aksw.jenax.dataaccess.sparql.common.WorkerThreadBase;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;

public class IteratorDelegateWithWorkerThread<T, I extends Iterator<T>>
extends PrefetchIterator<T>
implements IteratorCloseable<T> {
    protected WorkerThreadBase helper;
    protected int batchSize;
    protected I delegate;

    public IteratorDelegateWithWorkerThread(I delegate, ExecutorService es) {
        this(delegate, es, 128);
    }

    public IteratorDelegateWithWorkerThread(I delegate, ExecutorService es, int batchSize) {
        this.helper = new WorkerThreadBase(es);
        this.delegate = delegate;
        this.batchSize = batchSize;
    }

    public I getDelegate() {
        return this.delegate;
    }

    protected T copy(T item) {
        return item;
    }

    protected Iterator<T> prefetch() throws Exception {
        List batch = this.helper.submit(() -> {
            I d = this.getDelegate();
            ArrayList r = new ArrayList();
            for (int i = 0; i < this.batchSize && d.hasNext(); ++i) {
                Object rawItem = d.next();
                Object item = this.copy(rawItem);
                r.add(item);
            }
            return r;
        });
        return batch.isEmpty() ? null : batch.iterator();
    }

    public void close() {
        this.helper.submit(() -> Iter.close(this.getDelegate()));
    }
}

