/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.connection.common;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.jenax.arq.util.binding.QueryIterOverQueryExec;
import org.aksw.jenax.arq.util.dataset.DatasetDescriptionUtils;
import org.aksw.jenax.arq.util.dataset.DynamicDatasetUtils;
import org.aksw.jenax.arq.util.exec.query.QueryExecTransform;
import org.aksw.jenax.arq.util.exec.query.QueryExecUtils;
import org.aksw.jenax.arq.util.exec.query.QueryExecutionUtils;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderTransform;
import org.aksw.jenax.dataaccess.sparql.builder.exec.update.UpdateExecBuilderTransform;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionModular;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkUtils;
import org.aksw.jenax.dataaccess.sparql.link.common.RDFLinkWrapperWithCloseShield;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransform;
import org.aksw.jenax.stmt.core.SparqlStmtTransform;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionLocal;
import org.apache.jena.rdfconnection.RDFDatasetConnection;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.rdfconnection.SparqlUpdateConnection;
import org.apache.jena.rdflink.RDFConnectionAdapter;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpAsQuery;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.core.DatasetDescription;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DynamicDatasets;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.Rename;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterCommonParent;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIterSingleton;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class RDFConnectionUtils {
    public static RDFConnection withCloseShield(RDFConnection conn) {
        return RDFConnectionAdapter.adapt((RDFLink)new RDFLinkWrapperWithCloseShield(RDFLinkAdapter.adapt((RDFConnection)conn)));
    }

    public static SparqlQueryConnection unwrapQueryConnection(SparqlQueryConnection conn) {
        SparqlQueryConnection result;
        if (conn instanceof RDFConnectionModular) {
            SparqlQueryConnection tmp = RDFConnectionUtils.getQueryConnection((RDFConnectionModular)conn);
            result = RDFConnectionUtils.unwrapQueryConnection(tmp);
        } else {
            result = conn;
        }
        return result;
    }

    public static SparqlUpdateConnection unwrapUpdateConnection(SparqlUpdateConnection conn) {
        SparqlUpdateConnection result;
        if (conn instanceof RDFConnectionModular) {
            SparqlUpdateConnection tmp = RDFConnectionUtils.getUpdateConnection((RDFConnectionModular)conn);
            result = RDFConnectionUtils.unwrapUpdateConnection(tmp);
        } else {
            result = conn;
        }
        return result;
    }

    public static RDFDatasetConnection unwrapDatasetConnection(RDFDatasetConnection conn) {
        RDFDatasetConnection result;
        if (conn instanceof RDFConnectionModular) {
            RDFDatasetConnection tmp = RDFConnectionUtils.getDatasetConnection((RDFConnectionModular)conn);
            result = RDFConnectionUtils.unwrapDatasetConnection(tmp);
        } else {
            result = conn;
        }
        return result;
    }

    public static SparqlQueryConnection getQueryConnection(RDFConnectionModular conn) {
        SparqlQueryConnection result;
        try {
            Field f = RDFConnectionModular.class.getDeclaredField("queryConnection");
            f.setAccessible(true);
            result = (SparqlQueryConnection)f.get(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static SparqlUpdateConnection getUpdateConnection(RDFConnectionModular conn) {
        SparqlUpdateConnection result;
        try {
            Field f = RDFConnectionModular.class.getDeclaredField("updateConnection");
            f.setAccessible(true);
            result = (SparqlUpdateConnection)f.get(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static RDFDatasetConnection getDatasetConnection(RDFConnectionModular conn) {
        RDFDatasetConnection result;
        try {
            Field f = RDFConnectionModular.class.getDeclaredField("datasetConnection");
            f.setAccessible(true);
            result = (RDFDatasetConnection)f.get(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static Dataset getDataset(RDFConnectionLocal conn) {
        Dataset result;
        try {
            Field f = RDFConnectionLocal.class.getDeclaredField("dataset");
            f.setAccessible(true);
            result = (Dataset)f.get(conn);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public static RDFConnection wrapWithBuilderTransform(RDFConnection rawConn, QueryExecBuilderTransform queryBuilderTransform, UpdateExecBuilderTransform updateBuilderTransform) {
        return RDFConnectionUtils.wrapWithLinkTransform(rawConn, link -> RDFLinkUtils.wrapWithBuilderTransform(link, queryBuilderTransform, updateBuilderTransform));
    }

    public static RDFConnection wrapWithContextMutator(RDFConnection rawConn) {
        return RDFConnectionUtils.wrapWithContextMutator(rawConn, cxt -> {});
    }

    public static RDFConnection wrapWithContextMutator(RDFConnection rawConn, Consumer<Context> contextMutator) {
        RDFLink oldLink = RDFLinkAdapter.adapt((RDFConnection)rawConn);
        RDFLink newLink = RDFLinkUtils.wrapWithContextMutator(oldLink, contextMutator);
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)newLink);
        return result;
    }

    public static RDFConnection wrapWithLinkTransform(RDFConnection conn, RDFLinkTransform linkTransform) {
        RDFLink oldLink = RDFLinkAdapter.adapt((RDFConnection)conn);
        RDFLink newLink = (RDFLink)linkTransform.apply(oldLink);
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)newLink);
        return result;
    }

    public static RDFConnection wrapWithQueryTransform(RDFConnection conn, QueryTransform queryTransform) {
        return RDFConnectionUtils.wrapWithQueryTransform(conn, queryTransform, null);
    }

    public static RDFConnection wrapWithStmtTransform(RDFConnection conn, SparqlStmtTransform transform) {
        RDFLink oldLink = RDFLinkAdapter.adapt((RDFConnection)conn);
        RDFLink newLink = RDFLinkUtils.wrapWithStmtTransform(oldLink, transform);
        RDFConnection result = RDFConnectionAdapter.adapt((RDFLink)newLink);
        return result;
    }

    public static RDFConnection wrapWithQueryTransform(RDFConnection conn, QueryTransform queryTransform, QueryExecTransform queryExecTransform) {
        RDFLink oldLink = RDFLinkAdapter.adapt((RDFConnection)conn);
        RDFLink newLink = RDFLinkUtils.wrapWithQueryTransform(oldLink, queryTransform, queryExecTransform);
        return RDFConnectionAdapter.adapt((RDFLink)newLink);
    }

    public static RDFConnection wrapWithUpdateTransform(RDFConnection conn, Function<? super UpdateRequest, ? extends UpdateRequest> updateTransform, BiFunction<? super UpdateRequest, ? super UpdateProcessor, ? extends UpdateProcessor> updateExecTransform) {
        RDFLink oldLink = RDFLinkAdapter.adapt((RDFConnection)conn);
        RDFLink newLink = RDFLinkUtils.wrapWithUpdateTransform(oldLink, updateTransform, updateExecTransform);
        return RDFConnectionAdapter.adapt((RDFLink)newLink);
    }

    public static RDFConnection enableRelativeIrisInQueryResults(RDFConnection delegate) {
        return RDFConnectionUtils.wrapWithLinkTransform(delegate, RDFLinkUtils::enableRelativeIrisInQueryResults);
    }

    public static RDFConnection wrapWithQueryOnly(RDFConnection conn) {
        return RDFConnectionUtils.wrapWithLinkTransform(conn, RDFLinkUtils::wrapWithQueryOnly);
    }

    public static RDFConnection wrapWithAutoDisableReorder(RDFConnection conn) {
        return RDFConnectionUtils.wrapWithQueryTransform(conn, null, qe -> {
            QueryExecutionUtils.wrapWithAutoDisableReorder((Query)qe.getQuery(), (Context)qe.getContext());
            return qe;
        });
    }

    public static QueryIterator execService(Binding binding, ExecutionContext execCxt, OpService opService, RDFConnection target, boolean isStreamingAllowed, boolean applyDatasetDescription) {
        DynamicDatasets.DynamicDatasetGraph ddg;
        DatasetGraph dg;
        DatasetDescription dd = null;
        if (applyDatasetDescription && (dg = execCxt.getDataset()) != null && (ddg = DynamicDatasetUtils.asUnwrappableDynamicDatasetOrNull((DatasetGraph)dg)) != null) {
            dd = DatasetDescriptionUtils.ofNodes((Collection)ddg.getOriginalDefaultGraphs(), (Collection)ddg.getOriginalNamedGraphs());
        }
        QueryIterator qIter = RDFConnectionUtils.execService(opService, target, isStreamingAllowed, dd);
        qIter = QueryIter.makeTracked((QueryIterator)qIter, (ExecutionContext)execCxt);
        return new QueryIterCommonParent(qIter, binding, execCxt);
    }

    public static QueryIterator execService(OpService opService, RDFConnection target, boolean isStreamingAllowed, DatasetDescription datasetDescription) {
        boolean isSilent = opService.getSilent();
        Op opRemote = opService.getSubOp();
        Op opRestored = Rename.reverseVarRename((Op)opRemote, (boolean)true);
        Query query = OpAsQuery.asQuery((Op)opRestored);
        if (datasetDescription != null) {
            QueryUtils.overwriteDatasetDescription((Query)query, (DatasetDescription)datasetDescription);
        }
        Map varMapping = QueryExecUtils.computeVarMapping((Op)opRemote, (Op)opRestored);
        RDFLink link = RDFLinkAdapter.adapt((RDFConnection)target);
        QueryExecBuilder builder = link.newQuery().query(query);
        QueryIterator result = RDFConnectionUtils.exec(builder, isSilent, isStreamingAllowed);
        if (varMapping != null) {
            result = QueryIter.map((QueryIterator)result, (Map)varMapping);
        }
        return result;
    }

    public static QueryIterator exec(QueryExecBuilder builder, boolean isSilent, boolean isStreamingAllowed) {
        QueryIterSingleton result;
        block10: {
            if (isSilent || !isStreamingAllowed) {
                try (QueryExec qe = builder.build();){
                    RowSet rs = qe.select();
                    RowSet mat = rs.materialize();
                    result = QueryIterPlainWrapper.create((Iterator)mat);
                    break block10;
                }
                catch (RuntimeException ex) {
                    if (isSilent) {
                        result = QueryIterSingleton.create((Binding)BindingFactory.root(), null);
                        break block10;
                    }
                    ex.addSuppressed(new RuntimeException("QueryExecution error"));
                    throw ex;
                }
            }
            QueryExec queryExec = builder.build();
            result = new QueryIterOverQueryExec(null, queryExec);
        }
        return result;
    }
}

