/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.builder.exec.query;

import java.util.concurrent.TimeUnit;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecModCustomBase;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.Syntax;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public abstract class QueryExecBuilderCustomBase<T extends QueryExecBuilder>
extends QueryExecModCustomBase<T>
implements QueryExecBuilder {
    protected Query query;
    protected String queryString;
    protected Syntax querySyntax;
    protected Boolean parseCheck = null;
    protected BindingBuilder substitution = BindingFactory.builder();

    public QueryExecBuilderCustomBase() {
    }

    public QueryExecBuilderCustomBase(QueryExecBuilderCustomBase<?> that) {
        super(that);
        this.query = that.query;
        this.queryString = that.queryString;
        this.querySyntax = that.querySyntax;
        this.parseCheck = that.parseCheck;
        this.substitution = Binding.builder().addAll(that.substitution.build());
    }

    public Query getQuery() {
        return this.query;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public Syntax getQuerySyntax() {
        return this.querySyntax;
    }

    public BindingBuilder getSubstitution() {
        return this.substitution;
    }

    public Query getParsedQuery() {
        Query result = this.query != null ? this.query : (this.queryString != null ? QueryFactory.create((String)this.queryString, (Syntax)this.querySyntax) : null);
        return result;
    }

    public Query getParsedQueryCopy() {
        Query result = this.query != null ? this.query.cloneQuery() : (this.queryString != null ? QueryFactory.create((String)this.queryString, (Syntax)this.querySyntax) : null);
        return result;
    }

    public QueryExecBuilder query(Query query) {
        this.querySyntax = null;
        this.queryString = null;
        this.query = query;
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder query(String queryString) {
        this.query = null;
        this.querySyntax = null;
        this.queryString = queryString;
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder query(String queryString, Syntax syntax) {
        this.query = null;
        this.queryString = queryString;
        this.querySyntax = syntax;
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder parseCheck(boolean parseCheck) {
        this.parseCheck = parseCheck;
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder set(Symbol symbol, Object value) {
        this.getContext().set(symbol, value);
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder set(Symbol symbol, boolean value) {
        this.getContext().set(symbol, value);
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder context(Context context) {
        if (context != null) {
            for (Symbol key : context.keys()) {
                this.contextAccumulator.set(key, context.get(key));
            }
        }
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder substitution(Binding binding) {
        this.substitution.addAll(binding);
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder substitution(Var var, Node value) {
        this.substitution.add(var, value);
        return (QueryExecBuilder)this.self();
    }

    public QueryExecBuilder timeout(long value, TimeUnit timeUnit) {
        this.overallTimeout(value, timeUnit);
        return (QueryExecBuilder)this.self();
    }

    @Override
    public <X extends QueryExecBuilder> X applySettings(X dst) {
        super.applySettings(dst);
        if (this.parseCheck != null) {
            dst.parseCheck(this.parseCheck.booleanValue());
        }
        if (this.querySyntax != null) {
            dst.query(this.queryString, this.querySyntax);
        } else if (this.queryString != null) {
            dst.query(this.queryString);
        } else if (this.query != null) {
            dst.query(this.query);
        }
        Binding binding = this.substitution.build();
        this.substitution.reset().addAll(binding);
        if (!binding.isEmpty()) {
            dst.substitution(binding);
        }
        return dst;
    }
}

