/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.linksource.track;

import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.sparql.util.Symbol;

public class ExecTracker {
    protected AtomicLong nextId = new AtomicLong();
    protected ConcurrentMap<Long, StartRecord> idToStartRecord = new ConcurrentHashMap<Long, StartRecord>();
    protected int maxHistorySize = 1000;
    protected ConcurrentMap<Instant, CompletionRecord> history = new ConcurrentSkipListMap<Instant, CompletionRecord>();
    public static final Symbol symTracker = SystemARQ.allocSymbol((String)"execTracker");

    public ConcurrentMap<Instant, CompletionRecord> getHistory() {
        return this.history;
    }

    public void setMaxHistorySize(int maxHistorySize) {
        this.maxHistorySize = maxHistorySize;
    }

    public long put(Object requestObject, Runnable abortAction) {
        long result = this.nextId.getAndIncrement();
        StartRecord record = new StartRecord(result, Instant.now(), requestObject, abortAction);
        this.idToStartRecord.put(result, record);
        return result;
    }

    protected void trimHistory() {
        if (this.history.size() >= this.maxHistorySize) {
            Iterator it = this.history.entrySet().iterator();
            while (this.history.size() >= this.maxHistorySize && it.hasNext()) {
                it.next();
                it.remove();
            }
        }
    }

    public CompletionRecord remove(long id, Throwable t) {
        StartRecord startRecord = (StartRecord)this.idToStartRecord.remove(id);
        CompletionRecord result = null;
        if (startRecord != null) {
            this.trimHistory();
            Instant now = Instant.now();
            result = new CompletionRecord(startRecord, now, t);
            this.history.put(now, result);
        }
        return result;
    }

    public String toString() {
        return "Active: " + this.idToStartRecord.size() + ", History: " + this.history.size() + "/" + this.maxHistorySize;
    }

    public static ExecTracker getTracker(Context context) {
        return (ExecTracker)context.get(symTracker);
    }

    public static ExecTracker requireTracker(Context context) {
        ExecTracker result = ExecTracker.getTracker(context);
        Objects.requireNonNull("No ExecTracker registered in context");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecTracker ensureTracker(Context context) {
        ExecTracker result = (ExecTracker)context.get(symTracker);
        if (result == null) {
            Context context2 = context;
            synchronized (context2) {
                result = (ExecTracker)context.get(symTracker);
                if (result == null) {
                    result = new ExecTracker();
                    context.set(symTracker, (Object)result);
                }
            }
        }
        return result;
    }

    public record StartRecord(long requestId, Instant timestamp, Object requestObject, Runnable abortAction) {
    }

    public record CompletionRecord(StartRecord start, Instant timestamp, Throwable throwable) {
        public Duration duration() {
            return Duration.between(this.start.timestamp, this.timestamp);
        }

        public boolean isSuccess() {
            return this.throwable == null;
        }
    }
}

