/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.query;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.aksw.jenax.arq.util.binding.QueryIterOverQueryExec;
import org.aksw.jenax.arq.util.binding.QueryIterOverQueryIteratorSupplier;
import org.aksw.jenax.arq.util.binding.QueryIteratorCount;
import org.aksw.jenax.arq.util.exec.query.PaginationQueryIterator;
import org.aksw.jenax.arq.util.syntax.QueryUtils;
import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecBaseSelect;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecOverRowSet;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryWrapperBase;
import org.apache.jena.query.Query;
import org.apache.jena.rdflink.LinkSparqlQuery;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.RowSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkSparqlQueryTransformPaginate
implements LinkSparqlQueryTransform {
    protected long pageSize;

    public LinkSparqlQueryTransformPaginate(long pageSize) {
        if (pageSize <= 0L) {
            throw new IllegalArgumentException("Page size must be >= 1");
        }
        this.pageSize = pageSize;
    }

    @Override
    public LinkSparqlQuery apply(LinkSparqlQuery base) {
        return new LinkSparqlQueryWrapperBase(base){

            @Override
            public QueryExecBuilder newQuery() {
                LinkSparqlQuery tmp = this.getDelegate();
                return LinkSparqlQueryTransformPaginate.execSelectPaginated(tmp, LinkSparqlQueryTransformPaginate.this.pageSize);
            }
        };
    }

    public static QueryExecBuilder execSelectPaginated(final LinkSparqlQuery baseLink, final long pageSize) {
        return new QueryExecBuilderCustomBase<QueryExecBuilder>(){

            @Override
            public QueryExec build() {
                final QueryExecBuilderCustomBase<QueryExecBuilder> prototype = new QueryExecBuilderCustomBase<QueryExecBuilder>((QueryExecBuilderCustomBase)this){

                    @Override
                    public QueryExec build() {
                        throw new UnsupportedOperationException("should never be called");
                    }
                };
                Query parsedQuery = this.getParsedQuery();
                Objects.requireNonNull(parsedQuery, "Query not set");
                QueryExecBaseSelect r = new QueryExecBaseSelect(parsedQuery){

                    @Override
                    protected QueryExec doSelect(Query selectQuery) {
                        List vars = selectQuery.getProjectVars();
                        Supplier<QueryExecBuilder> queryExecBuilderSupplier = () -> prototype.applySettings(baseLink.newQuery());
                        QueryIterPaginated qIter = QueryIterPaginated.of(selectQuery, pageSize, queryExecBuilderSupplier);
                        RowSet rowSet = RowSet.create((QueryIterator)qIter, (List)vars);
                        return new QueryExecOverRowSet.QueryExecOverRowSetInternal(rowSet);
                    }
                };
                return r;
            }
        };
    }

    public static class QueryIterPaginated
    extends QueryIterOverQueryIteratorSupplier<QueryIteratorCount> {
        private static final Logger logger = LoggerFactory.getLogger(QueryIterPaginated.class);
        protected static final AtomicLong idGenerator = new AtomicLong();
        protected Query originalQuery;
        protected PaginationQueryIterator queryIt;
        protected Supplier<QueryExecBuilder> queryExecBuilderSupplier;
        protected long execId = -1L;

        public QueryIterPaginated(Query originalQuery, PaginationQueryIterator queryIt, Supplier<QueryExecBuilder> queryExecBuilderSupplier) {
            super(null);
            this.originalQuery = originalQuery;
            this.queryIt = queryIt;
            this.queryExecBuilderSupplier = queryExecBuilderSupplier;
        }

        protected QueryIteratorCount nextQueryIterator() {
            if (this.execId == -1L) {
                this.execId = idGenerator.getAndUpdate(x -> x == Long.MAX_VALUE ? 0L : x + 1L);
                if (logger.isInfoEnabled()) {
                    logger.info("Paginated execution #" + this.execId + " started:\n" + String.valueOf(this.originalQuery));
                }
            }
            long pageSize = this.queryIt.getPageSize();
            long lastItemCount = this.currentIt == null ? pageSize : ((QueryIteratorCount)this.currentIt).getCounter();
            QueryIteratorCount result = null;
            if (lastItemCount >= pageSize && this.queryIt.hasNext()) {
                Query query = (Query)this.queryIt.next();
                if (query != null) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Paginated execution #" + this.execId + " processing range: " + String.valueOf(QueryUtils.toRange((Query)query)));
                    }
                    QueryExecBuilder queryExecBuilder = this.queryExecBuilderSupplier.get();
                    QueryExec queryExec = queryExecBuilder.query(query).build();
                    result = new QueryIteratorCount((QueryIterator)new QueryIterOverQueryExec(this.getExecContext(), queryExec));
                }
            } else if (logger.isInfoEnabled()) {
                logger.info("Paginated execution #" + this.execId + " finished (consumed).");
            }
            return result;
        }

        protected void closeIteratorActual() {
            if (this.execId >= 0L && !this.isFinished && logger.isInfoEnabled()) {
                logger.info("Paginated execution #" + this.execId + " finished (closed).");
            }
            super.closeIteratorActual();
        }

        public static QueryIterPaginated of(Query query, long pageSize, Supplier<QueryExecBuilder> queryExecBuilderSupplier) {
            Query clone = query.cloneQuery();
            PaginationQueryIterator queryIt = new PaginationQueryIterator(clone, pageSize);
            return new QueryIterPaginated(query, queryIt, queryExecBuilderSupplier);
        }
    }
}

