/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.execution.update;

import org.aksw.jenax.dataaccess.sparql.execution.update.UpdateEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.execution.update.UpdateProcessorWrapperTxn;
import org.aksw.jenax.dataaccess.sparql.factory.execution.update.UpdateProcessorFactory;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Dataset;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingRoot;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.modify.UpdateProcessorBase;
import org.apache.jena.sparql.util.Context;
import org.apache.jena.update.UpdateProcessor;
import org.apache.jena.update.UpdateRequest;

public class UpdateProcessorFactoryDataset
implements UpdateProcessorFactory {
    protected Dataset dataset;
    protected Context context;
    protected UpdateEngineFactoryProvider updateEngineFactoryProvider;

    public UpdateProcessorFactoryDataset(Dataset dataset) {
        this(dataset, null);
    }

    public UpdateProcessorFactoryDataset(Dataset dataset, Context context) {
        this(dataset, context, (arg_0, arg_1) -> ((UpdateEngineRegistry)UpdateEngineRegistry.get()).find(arg_0, arg_1));
    }

    public UpdateProcessorFactoryDataset(Dataset dataset, Context context, UpdateEngineFactoryProvider updateEngineFactoryProvider) {
        this.dataset = dataset;
        this.context = context;
        this.updateEngineFactoryProvider = updateEngineFactoryProvider;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public Context getContext() {
        return this.context;
    }

    @Override
    public UpdateProcessor createUpdateProcessor(UpdateRequest updateRequest) {
        UpdateEngineFactory f;
        if (this.context == null) {
            this.context = ARQ.getContext();
        }
        DatasetGraph dsg = null;
        if (this.dataset != null) {
            dsg = this.dataset.asDatasetGraph();
        }
        if ((f = this.updateEngineFactoryProvider.find(dsg, this.context)) == null) {
            Log.warn(UpdateProcessorFactoryDataset.class, (String)("Failed to find a UpdateEngineFactory for update: " + String.valueOf(updateRequest)));
            return null;
        }
        Context cxt = Context.setupContextForDataset((Context)this.context, (DatasetGraph)dsg);
        Binding initialBinding = BindingRoot.create();
        UpdateProcessorBase tmp = new UpdateProcessorBase(updateRequest, dsg, initialBinding, cxt, f, Timeouts.Timeout.UNSET);
        UpdateProcessor result = UpdateProcessorWrapperTxn.wrap(tmp, (Transactional)dsg);
        return result;
    }
}

