/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.exec.query;

import java.util.Iterator;
import org.aksw.jenax.arq.util.node.NodeTransformLib2;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecWrapper;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.RowSet;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.graph.NodeTransform;
import org.apache.jena.sparql.graph.NodeTransformLib;
import org.apache.jena.util.iterator.WrappedIterator;

public class QueryExecWithNodeTransform
implements QueryExecWrapper {
    protected QueryExec decoratee;
    protected NodeTransform nodeTransform;

    public QueryExecWithNodeTransform(QueryExec decoratee, NodeTransform nodeTransform) {
        this.decoratee = decoratee;
        this.nodeTransform = nodeTransform;
    }

    @Override
    public QueryExec getDelegate() {
        return this.decoratee;
    }

    @Override
    public DatasetGraph getDataset() {
        return this.getDelegate().getDataset();
    }

    @Override
    public RowSet select() {
        return NodeTransformLib2.applyNodeTransform((NodeTransform)this.nodeTransform, (RowSet)this.getDelegate().select());
    }

    @Override
    public Graph construct() {
        Graph graph = GraphFactory.createDefaultGraph();
        this.construct(graph);
        return graph;
    }

    @Override
    public Graph construct(Graph graph) {
        this.constructTriples().forEachRemaining(arg_0 -> ((Graph)graph).add(arg_0));
        return graph;
    }

    @Override
    public Iterator<Triple> constructTriples() {
        return WrappedIterator.create((Iterator)this.getDelegate().constructTriples()).mapWith(t -> NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Triple)t));
    }

    @Override
    public Iterator<Quad> constructQuads() {
        return WrappedIterator.create((Iterator)this.getDelegate().constructQuads()).mapWith(q -> NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Quad)q));
    }

    @Override
    public DatasetGraph constructDataset(DatasetGraph dataset) {
        this.constructQuads().forEachRemaining(arg_0 -> ((DatasetGraph)dataset).add(arg_0));
        return dataset;
    }

    @Override
    public Graph describe(Graph graph) {
        this.describeTriples().forEachRemaining(arg_0 -> ((Graph)graph).add(arg_0));
        return graph;
    }

    @Override
    public Iterator<Triple> describeTriples() {
        return WrappedIterator.create((Iterator)this.getDelegate().describeTriples()).mapWith(t -> NodeTransformLib.transform((NodeTransform)this.nodeTransform, (Triple)t));
    }

    @Override
    public boolean ask() {
        return this.getDelegate().ask();
    }

    @Override
    public JsonArray execJson() {
        return this.getDelegate().execJson();
    }

    @Override
    public Iterator<JsonObject> execJsonItems() {
        return this.getDelegate().execJsonItems();
    }
}

