/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.dataset.engine;

import java.util.Iterator;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.exec.query.FragmentExec;
import org.aksw.jenax.dataaccess.sparql.exec.query.QueryExecUtils;
import org.aksw.jenax.sparql.fragment.impl.ConceptUtils;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.iterator.IteratorCloseable;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.PrefixMapFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.DatasetGraphBaseFind;
import org.apache.jena.sparql.core.GraphView;
import org.apache.jena.sparql.core.Quad;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.exec.QueryExec;

public class DatasetGraphOverRDFEngine
extends DatasetGraphBaseFind {
    protected RDFEngine engine;
    protected PrefixMap prefixes = PrefixMapFactory.emptyPrefixMap();

    public DatasetGraphOverRDFEngine(RDFEngine engine) {
        this.engine = engine;
    }

    public static DatasetGraphOverRDFEngine of(RDFEngine engine) {
        return new DatasetGraphOverRDFEngine(engine);
    }

    public RDFEngine getEngine() {
        return this.engine;
    }

    protected QueryExec exec(Query query) {
        return this.engine.getLinkSource().query(query);
    }

    public Iterator<Node> listGraphNodes() {
        return FragmentExec.execNode(this::exec, ConceptUtils.listAllGraphs);
    }

    protected Iterator<Quad> findInDftGraph(Node s, Node p, Node o) {
        IteratorCloseable<Triple> base = QueryExecUtils.findTriples(this::exec, s, p, o);
        Iterator result = Iter.map(base, t -> Quad.create((Node)Quad.defaultGraphIRI, (Triple)t));
        return result;
    }

    protected Iterator<Quad> findInSpecificNamedGraph(Node g, Node s, Node p, Node o) {
        IteratorCloseable<Quad> result = QueryExecUtils.findQuads(this::exec, g, s, p, o);
        return result;
    }

    protected Iterator<Quad> findInAnyNamedGraphs(Node s, Node p, Node o) {
        IteratorCloseable<Quad> result = QueryExecUtils.findQuads(this::exec, Node.ANY, s, p, o);
        return result;
    }

    public Graph getDefaultGraph() {
        return GraphView.createDefaultGraph((DatasetGraph)this);
    }

    public Graph getGraph(Node graphNode) {
        return GraphView.createNamedGraph((DatasetGraph)this, (Node)graphNode);
    }

    public void addGraph(Node graphName, Graph graph) {
        throw new UnsupportedOperationException();
    }

    public void removeGraph(Node graphName) {
        throw new UnsupportedOperationException();
    }

    public boolean supportsTransactions() {
        return false;
    }

    public void abort() {
    }

    public void begin(ReadWrite arg0) {
    }

    public void commit() {
    }

    public void end() {
    }

    public boolean isInTransaction() {
        return false;
    }

    public void begin(TxnType type) {
    }

    public boolean promote(Transactional.Promote mode) {
        return false;
    }

    public ReadWrite transactionMode() {
        return ReadWrite.READ;
    }

    public TxnType transactionType() {
        return null;
    }

    public PrefixMap prefixes() {
        return this.prefixes;
    }
}

