/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.common;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class WorkerThreadBase {
    protected ExecutorService es;

    public WorkerThreadBase() {
        this(null);
    }

    public WorkerThreadBase(ExecutorService es) {
        this.es = es;
    }

    public static <T> T submit(ExecutorService executorService, Callable<T> callable) {
        try {
            return executorService.submit(callable).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void submit(Runnable runnable) {
        this.submit(() -> {
            runnable.run();
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T submit(Callable<T> callable) {
        if (this.es == null) {
            WorkerThreadBase workerThreadBase = this;
            synchronized (workerThreadBase) {
                if (this.es == null) {
                    this.es = Executors.newSingleThreadExecutor();
                }
            }
        }
        T result = WorkerThreadBase.submit(this.es, callable);
        return result;
    }
}

