/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.detector;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.polyfill.datasource.Suggestion;
import org.aksw.jenax.dataaccess.sparql.polyfill.detector.Condition;
import org.aksw.jenax.dataaccess.sparql.polyfill.detector.ConditionProcessor;
import org.aksw.jenax.model.polyfill.domain.api.PolyfillCondition;
import org.aksw.jenax.model.polyfill.domain.api.PolyfillConditionVisitor;
import org.aksw.jenax.model.polyfill.domain.api.PolyfillRewriteJava;
import org.aksw.jenax.model.polyfill.domain.api.PolyfillSuggestionRule;
import org.aksw.jenax.model.polyfill.domain.api.PolyfillVocab;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;

public class PolyfillDetector {
    protected NavigableMap<Integer, List<Record>> suggesters = new TreeMap<Integer, List<Record>>();

    public List<Suggestion<String>> detect(RDFDataSource dataSource) {
        ArrayList<Suggestion<String>> result = new ArrayList<Suggestion<String>>();
        for (Map.Entry entry : this.suggesters.entrySet()) {
            for (Record e : (List)entry.getValue()) {
                Condition condition = e.condition;
                PolyfillSuggestionRule suggester = e.suggester;
                boolean value = condition == null ? true : condition.test(dataSource);
                if (!value) continue;
                Suggestion<String> contrib = Suggestion.of(suggester.getLabel(), suggester.getComment(), e.javaClass);
                result.add(contrib);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load(Model model) {
        ConditionProcessor conditionProcessor = ConditionProcessor.get();
        try (ExtendedIterator it = model.listResourcesWithProperty(PolyfillVocab.suggestion).mapWith(x -> (PolyfillSuggestionRule)x.as(PolyfillSuggestionRule.class));){
            while (it.hasNext()) {
                PolyfillSuggestionRule suggester = (PolyfillSuggestionRule)it.next();
                PolyfillCondition conditionData = suggester.getCondition();
                Condition condition = conditionData == null ? null : (Condition)conditionData.accept((PolyfillConditionVisitor)conditionProcessor);
                Integer level = suggester.getLevel();
                Resource rewriterData = suggester.getSuggestion();
                if (rewriterData == null) {
                    throw new NullPointerException("Suggestion is not set: " + String.valueOf(suggester));
                }
                if (rewriterData instanceof PolyfillRewriteJava) {
                    PolyfillRewriteJava tmp = (PolyfillRewriteJava)rewriterData;
                    String javaClass = tmp.getJavaClass();
                    Record record = new Record(suggester, condition, javaClass);
                    int effectiveLevel = level == null ? 1000000 : level;
                    this.suggesters.computeIfAbsent(effectiveLevel, k -> new ArrayList()).add(record);
                    continue;
                }
                throw new RuntimeException("Unsupported suggestion type: " + String.valueOf(rewriterData.getClass()));
            }
        }
    }

    private static class Record {
        protected PolyfillSuggestionRule suggester;
        protected Condition condition;
        protected String javaClass;

        public Record(PolyfillSuggestionRule suggester, Condition condition, String javaClass) {
            this.suggester = suggester;
            this.condition = condition;
            this.javaClass = javaClass;
        }
    }
}

