/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.link.dataset;

import org.aksw.jenax.dataaccess.sparql.link.dataset.LinkDatasetGraphWrapperBase;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.rdflink.LinkDatasetGraph;
import org.apache.jena.sparql.core.Transactional;

public class LinkDatasetGraphWrapperTxn<T extends LinkDatasetGraph>
extends LinkDatasetGraphWrapperBase<T> {
    protected Transactional transactional;
    protected boolean startedTxnHere = false;
    protected Throwable seenThrowable = null;

    public LinkDatasetGraphWrapperTxn(T delegate, Transactional transactional) {
        super(delegate);
        this.transactional = transactional;
    }

    @Override
    public Transactional getTransactionalDelegate() {
        return this.transactional;
    }

    @Override
    public void beforeExec() {
        super.beforeExec();
        if (!this.transactional.isInTransaction()) {
            this.startedTxnHere = true;
            this.transactional.begin(ReadWrite.WRITE);
        }
    }

    @Override
    public void onException(Exception e) {
        this.seenThrowable = e;
        super.onException(e);
    }

    @Override
    public void close() {
        if (this.startedTxnHere) {
            try {
                if (this.seenThrowable == null) {
                    this.transactional.commit();
                } else {
                    this.transactional.abort();
                }
            }
            finally {
                this.transactional.end();
            }
        }
        super.close();
    }

    public static <T extends LinkDatasetGraph> LinkDatasetGraph wrap(T decoratee, Transactional transactional) {
        return new LinkDatasetGraphWrapperTxn<T>(decoratee, transactional);
    }
}

