/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Objects;
import org.aksw.jenax.arq.util.exec.query.QueryExecTransform;
import org.aksw.jenax.arq.util.op.OpTransform;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.arq.util.update.UpdateRequestTransform;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.DecoratedRDFEngine;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilder;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilderTransform;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransform;
import org.aksw.jenax.dataaccess.sparql.linksource.DecoratedRDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceDecorator;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceTransform;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.sparql.expr.ExprTransform;

public class RDFEngineDecorator<X extends RDFEngine> {
    protected X baseEngine;
    protected RDFLinkSourceDecorator linkSourceDecorator;
    protected Deque<Closeable> closeActions = new ArrayDeque<Closeable>();

    public RDFEngineDecorator(X baseEngine) {
        this.baseEngine = (RDFEngine)Objects.requireNonNull(baseEngine);
        this.linkSourceDecorator = new RDFLinkSourceDecorator(baseEngine.getLinkSource());
    }

    public RDFLinkSource snapshotLinkSource() {
        return this.linkSourceDecorator.snapshotLinkSource();
    }

    public RDFLinkBuilder snapshotLinkBuilder() {
        return this.linkSourceDecorator.snapshotLinkBuilder();
    }

    public RDFLink snapshotLink() {
        return this.linkSourceDecorator.snapshotLink();
    }

    public RDFEngineDecorator<X> addLinkBuilderMod(RDFLinkBuilderTransform linkBuilderMod) {
        this.linkSourceDecorator.addLinkBuilderMod(linkBuilderMod);
        return this;
    }

    public DecoratedRDFEngine<X> build() {
        DecoratedRDFLinkSource effectiveLinkSource = this.linkSourceDecorator.build();
        return new DecoratedRDFEngine<X>(this.baseEngine, effectiveLinkSource, new ArrayDeque<Closeable>(this.closeActions));
    }

    public RDFEngineDecorator<X> addCloseAction(Closeable closeAction) {
        Objects.requireNonNull(closeAction);
        this.closeActions.add(closeAction);
        return this;
    }

    public RDFEngineDecorator<X> decorate(RDFLinkSourceTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(RDFLinkTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(QueryTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(QueryExecTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(UpdateRequestTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(LinkSparqlQueryTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(OpTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }

    public RDFEngineDecorator<X> decorate(ExprTransform transform) {
        this.linkSourceDecorator.decorate(transform);
        return this;
    }
}

