/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.common;

import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import org.aksw.jenax.dataaccess.sparql.common.MultiplexUtils;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.query.TxnType;
import org.apache.jena.sparql.core.Transactional;

public class TransactionalMultiplex<T extends Transactional>
implements Transactional {
    protected List<? extends T> delegates;

    @SafeVarargs
    public TransactionalMultiplex(T ... delegates) {
        this(Arrays.asList(delegates));
    }

    public TransactionalMultiplex(List<? extends T> delegates) {
        this.delegates = delegates;
    }

    protected void forEach(Consumer<? super T> handler) {
        this.forEachR(delegate -> {
            handler.accept(delegate);
            return null;
        });
    }

    protected <X> X forEachR(Function<? super T, X> handler) {
        return MultiplexUtils.forEachAndReturnFirst(this.delegates, handler);
    }

    public void begin(ReadWrite readWrite) {
        this.forEach(d -> d.begin(readWrite));
    }

    public void commit() {
        this.forEach(Transactional::commit);
    }

    public void abort() {
        this.forEach(Transactional::abort);
    }

    public void end() {
        new ReverseListIterator(this.delegates).forEachRemaining(Transactional::end);
    }

    public boolean isInTransaction() {
        Transactional firstDelegate = this.delegates.isEmpty() ? null : (Transactional)this.delegates.iterator().next();
        boolean result = firstDelegate == null ? false : firstDelegate.isInTransaction();
        return result;
    }

    public void begin(TxnType type) {
        this.forEach(d -> d.begin(type));
    }

    public boolean promote(Transactional.Promote mode) {
        return this.forEachR(d -> d.promote(mode));
    }

    public ReadWrite transactionMode() {
        return this.forEachR(Transactional::transactionMode);
    }

    public TxnType transactionType() {
        return this.forEachR(Transactional::transactionType);
    }
}

