/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.linksource.track;

import java.util.concurrent.atomic.AtomicBoolean;
import org.aksw.jenax.dataaccess.sparql.linksource.track.DatasetGraphWithExecTracker;
import org.aksw.jenax.dataaccess.sparql.linksource.track.ExecTracker;
import org.aksw.jenax.dataaccess.sparql.linksource.track.UpdateEngineWrapperBase;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.modify.UpdateEngine;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.util.Context;

public class UpdateEngineFactoryExecTracker
implements UpdateEngineFactory {
    public boolean accept(DatasetGraph datasetGraph, Context context) {
        boolean result = false;
        if (datasetGraph instanceof DatasetGraphWithExecTracker) {
            DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)datasetGraph;
            DatasetGraph backend = tracker.getWrapped();
            result = UpdateEngineRegistry.findFactory((DatasetGraph)backend, (Context)context).accept((DatasetGraph)tracker, context);
        }
        return result;
    }

    public UpdateEngine create(DatasetGraph datasetGraph, Binding inputBinding, final Context context) {
        DatasetGraphWithExecTracker tracker = (DatasetGraphWithExecTracker)datasetGraph;
        final ExecTracker execTracker = ExecTracker.requireTracker(tracker.getContext());
        DatasetGraph backend = tracker.getWrapped();
        UpdateEngine base = UpdateEngineRegistry.findFactory((DatasetGraph)backend, (Context)context).create((DatasetGraph)tracker, inputBinding, context);
        final long[] idRef = new long[]{-1L};
        UpdateEngineWrapperBase result = new UpdateEngineWrapperBase(base){

            @Override
            public void startRequest() {
                AtomicBoolean cancelSignal = Context.getCancelSignal((Context)context);
                Runnable cancelAction = cancelSignal == null ? null : () -> cancelSignal.set(true);
                idRef[0] = execTracker.put("Update request", cancelAction);
                super.startRequest();
            }

            @Override
            public void finishRequest() {
                execTracker.remove(idRef[0], null);
                super.finishRequest();
            }
        };
        return result;
    }
}

