/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.linksource;

import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceAdapter;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilder;
import org.aksw.jenax.dataaccess.sparql.link.builder.RDFLinkBuilderOverLinkSupplier;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdflink.RDFLink;
import org.apache.jena.rdflink.RDFLinkAdapter;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecBuilder;

public class RDFLinkSourceAdapter
implements RDFLinkSource {
    protected RDFDataSource delegate;

    public RDFLinkSourceAdapter(RDFDataSource delegate) {
        this.delegate = Objects.requireNonNull(delegate);
    }

    @Override
    public DatasetGraph getDatasetGraph() {
        Dataset ds = this.asDataSource().getDataset();
        DatasetGraph result = ds == null ? null : ds.asDatasetGraph();
        return result;
    }

    @Override
    public RDFDataSource asDataSource() {
        return this.delegate;
    }

    @Override
    public RDFLinkBuilder<?> newLinkBuilder() {
        return new RDFLinkBuilderOverLinkSupplier(this::newLink);
    }

    @Override
    public RDFLink newLink() {
        RDFConnection conn = this.asDataSource().getConnection();
        RDFLink result = RDFLinkAdapter.adapt((RDFConnection)conn);
        return result;
    }

    @Override
    public QueryExecBuilder newQuery() {
        RDFLinkSource view = () -> this.newLinkBuilder();
        QueryExecBuilder result = view.newQuery();
        return result;
    }

    @Override
    public UpdateExecBuilder newUpdate() {
        RDFLinkSource view = () -> this.newLinkBuilder();
        UpdateExecBuilder result = view.newUpdate();
        return result;
    }

    public static RDFLinkSource adapt(RDFDataSource dataSource) {
        RDFLinkSource rDFLinkSource;
        if (dataSource instanceof RDFDataSourceAdapter) {
            RDFDataSourceAdapter adapter = (RDFDataSourceAdapter)dataSource;
            rDFLinkSource = adapter.asLinkSource();
        } else {
            rDFLinkSource = new RDFLinkSourceAdapter(dataSource);
        }
        RDFLinkSource result = rDFLinkSource;
        return result;
    }
}

