/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataset.connection;

import org.aksw.jenax.dataaccess.sparql.builder.exec.query.QueryExecBuilderCustomBase;
import org.aksw.jenax.dataaccess.sparql.factory.engine.query.QueryEngineFactoryProvider;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.Timeouts;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.exec.QueryExec;
import org.apache.jena.sparql.exec.QueryExecDataset;
import org.apache.jena.sparql.util.Context;

public class QueryExecDatasetBuilderEx<T extends QueryExecDatasetBuilderEx<T>>
extends QueryExecBuilderCustomBase<T> {
    protected DatasetGraph dataset;
    protected QueryEngineFactoryProvider queryEngineFactoryProvider;

    public QueryExecDatasetBuilderEx() {
    }

    public QueryExecDatasetBuilderEx(DatasetGraph dataset, QueryEngineFactoryProvider queryEngineFactoryProvider) {
        this();
        this.dataset(dataset);
        this.queryEngineFactoryProvider(queryEngineFactoryProvider);
    }

    public T dataset(DatasetGraph dataset) {
        this.dataset = dataset;
        return (T)((QueryExecDatasetBuilderEx)this.self());
    }

    public T queryEngineFactoryProvider(QueryEngineFactoryProvider queryEngineFactoryProvider) {
        this.queryEngineFactoryProvider = queryEngineFactoryProvider;
        return (T)((QueryExecDatasetBuilderEx)this.self());
    }

    @Override
    public QueryExec build() {
        Query query = this.getParsedQuery();
        Context localCxt = this.getContext();
        Context finalCxt = Context.setupContextForDataset((Context)localCxt, (DatasetGraph)this.dataset);
        query.setResultVars();
        QueryEngineFactory f = this.queryEngineFactoryProvider.find(query, this.dataset, finalCxt);
        if (f == null) {
            Log.warn(QueryExecutionFactory.class, (String)("Failed to find a QueryEngineFactory for query: " + String.valueOf(query)));
            return null;
        }
        Binding initialBinding = this.substitution.build();
        QueryExecDatasetBuilderEx.defaultTimeoutsFromContext(this, finalCxt);
        QueryExecDataset qExec = new QueryExecDataset(query, query.toString(), this.dataset, finalCxt, f, Timeouts.Timeout.UNSET, initialBinding){};
        return qExec;
    }
}

