/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataset.connection;

import java.util.Objects;
import org.aksw.jenax.dataaccess.sparql.execution.update.UpdateEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.DatasetRDFConnectionFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataset.connection.DatasetRDFConnectionFactoryImpl;
import org.aksw.jenax.dataaccess.sparql.factory.engine.query.QueryEngineFactoryProvider;
import org.aksw.jenax.dataaccess.sparql.factory.engine.update.UpdateEngineFactoryCore;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.engine.QueryEngineFactory;
import org.apache.jena.sparql.engine.QueryEngineRegistry;
import org.apache.jena.sparql.modify.UpdateEngineFactory;
import org.apache.jena.sparql.modify.UpdateEngineRegistry;
import org.apache.jena.sparql.util.Context;

public class DatasetRDFConnectionFactoryBuilder {
    protected QueryEngineFactoryProvider queryEngineFactoryProvider = null;
    protected UpdateEngineFactoryProvider updateEngineFactoryProvider = null;
    protected Context context;

    public static RDFConnection connect(Dataset dataset) {
        return DatasetRDFConnectionFactoryBuilder.createWithDefaults().build().connect(dataset);
    }

    public static DatasetRDFConnectionFactoryBuilder create() {
        return new DatasetRDFConnectionFactoryBuilder();
    }

    public static DatasetRDFConnectionFactoryBuilder createWithDefaults() {
        return DatasetRDFConnectionFactoryBuilder.create().setDefaultQueryEngineFactoryProvider().setDefaultUpdateEngineFactoryProvider();
    }

    public DatasetRDFConnectionFactoryBuilder setQueryEngineFactoryProvider(QueryEngineFactoryProvider queryEngineFactoryProvider) {
        this.queryEngineFactoryProvider = queryEngineFactoryProvider;
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setQueryEngineFactoryProvider(QueryEngineFactory queryEngineFactory) {
        this.queryEngineFactoryProvider = (query, dataset, context) -> queryEngineFactory;
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setDefaultQueryEngineFactoryProvider() {
        this.queryEngineFactoryProvider = QueryEngineRegistry::findFactory;
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setUpdateEngineFactoryCore(UpdateEngineFactoryCore updateEngineFactoryCore) {
        return this.setUpdateEngineFactory(updateEngineFactoryCore.asFactory());
    }

    public DatasetRDFConnectionFactoryBuilder setUpdateEngineFactoryProvider(UpdateEngineFactoryProvider updateEngineFactoryProvider) {
        this.updateEngineFactoryProvider = updateEngineFactoryProvider;
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setUpdateEngineFactory(UpdateEngineFactory updateEngineFactory) {
        this.updateEngineFactoryProvider = (dataset, context) -> updateEngineFactory;
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setDefaultUpdateEngineFactoryProvider() {
        this.updateEngineFactoryProvider = (dataset, context) -> UpdateEngineRegistry.findFactory((DatasetGraph)dataset, (Context)context);
        return this;
    }

    public DatasetRDFConnectionFactoryBuilder setContext(Context context) {
        this.context = context;
        return this;
    }

    public DatasetRDFConnectionFactory build() {
        Objects.requireNonNull(this.queryEngineFactoryProvider);
        Objects.requireNonNull(this.updateEngineFactoryProvider);
        return new DatasetRDFConnectionFactoryImpl(this.context, this.queryEngineFactoryProvider, this.updateEngineFactoryProvider);
    }
}

