/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.polyfill.datasource;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import org.aksw.jena_sparql_api.algebra.expr.transform.ExprTransformVirtualBnodeUris;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceWrapperBase;
import org.aksw.jenax.dataaccess.sparql.polyfill.datasource.RdfDataSourcePolyfill;
import org.aksw.jenax.stmt.core.SparqlStmtMgr;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.riot.RDFDataMgr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RdfDataSourceWithBnodeRewrite
extends RDFDataSourceWrapperBase<RDFDataSource> {
    private static final Logger logger = LoggerFactory.getLogger(RdfDataSourceWithBnodeRewrite.class);
    public static final String AUTO = "auto";
    protected String givenProfileName;
    protected String derivedProfileName;
    protected Optional<ExprTransformVirtualBnodeUris> transformer = null;

    public RdfDataSourceWithBnodeRewrite(RDFDataSource delegate, String givenProfileName) {
        super(delegate);
        this.givenProfileName = givenProfileName;
        this.derivedProfileName = null;
    }

    public String getGivenProfileName() {
        return this.givenProfileName;
    }

    public String getInferredProfileName() {
        return this.derivedProfileName;
    }

    public static ExprTransformVirtualBnodeUris getTransform(String profile) {
        Model model = RDFDataMgr.loadModel((String)"bnode-rewrites.ttl");
        SparqlStmtMgr.execSparql((Model)model, (String)"udf-inferences.rq");
        HashSet<String> activeProfiles = new HashSet<String>(Arrays.asList("http://ns.aksw.org/profile/" + profile));
        ExprTransformVirtualBnodeUris result = ExprTransformVirtualBnodeUris.createTransformFromUdfModel((Model)model, activeProfiles);
        return result;
    }

    @Override
    public RDFConnection getConnection() {
        RDFConnection result;
        RDFConnection base = this.getDelegate().getConnection();
        if (this.transformer == null) {
            this.derivedProfileName = AUTO.equalsIgnoreCase(this.givenProfileName) ? RdfDataSourcePolyfill.detectProfile(base) : this.givenProfileName;
            if (this.derivedProfileName != null) {
                ExprTransformVirtualBnodeUris tmp = RdfDataSourceWithBnodeRewrite.getTransform(this.derivedProfileName);
                this.transformer = Optional.ofNullable(tmp);
            } else {
                this.transformer = Optional.empty();
            }
        }
        if (this.transformer.isPresent()) {
            result = RDFConnectionUtils.wrapWithQueryTransform(base, arg_0 -> ((ExprTransformVirtualBnodeUris)this.transformer.get()).rewrite(arg_0));
        } else {
            logger.warn("No bnode profile found - bnodes are not supported");
            result = base;
        }
        return result;
    }

    public static RdfDataSourceWithBnodeRewrite wrapWithAutoBnodeProfileDetection(RDFDataSource delegatee) {
        return new RdfDataSourceWithBnodeRewrite(delegatee, AUTO);
    }
}

