/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.datasource;

import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.aksw.jenax.arq.util.exec.query.QueryExecTransform;
import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.arq.util.update.UpdateRequestTransform;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionModular;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSource;
import org.aksw.jenax.dataaccess.sparql.datasource.RDFDataSourceOverDataset;
import org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransform;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactory;
import org.aksw.jenax.dataaccess.sparql.factory.dataengine.RDFEngineFactoryRegistry;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceSpecBasicFromMap;
import org.aksw.jenax.dataaccess.sparql.factory.datasource.RdfDataSourceTransforms;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactories;
import org.aksw.jenax.dataaccess.sparql.link.query.LinkSparqlQueryTransform;
import org.aksw.jenax.dataaccess.sparql.link.transform.RDFLinkTransform;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceTransform;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSources;
import org.aksw.jenax.stmt.core.SparqlStmtTransform;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.rdfconnection.RDFConnectionRemote;
import org.apache.jena.rdfconnection.SparqlQueryConnection;
import org.apache.jena.sparql.algebra.optimize.Rewrite;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.expr.ExprTransform;
import org.apache.jena.sparql.function.user.UserDefinedFunctionDefinition;
import org.apache.jena.system.Txn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFDataSources {
    private static final Logger logger = LoggerFactory.getLogger(RDFDataSources.class);

    public static RDFDataSource alwaysFail() {
        RDFDataSource dummy = () -> RDFConnectionRemote.newBuilder().destination("urn:dummy").parseCheckSPARQL(false).build();
        RDFDataSource result = RDFDataSources.decorate(dummy, RdfDataSourceTransforms.alwaysFail());
        return result;
    }

    public static RDFDataSource of(Graph graph) {
        Model model = ModelFactory.createModelForGraph((Graph)graph);
        return RDFDataSources.of(model);
    }

    public static RDFDataSource of(DatasetGraph dsg) {
        Dataset ds = DatasetFactory.wrap((DatasetGraph)dsg);
        return RDFDataSources.of(ds);
    }

    public static RDFDataSource of(Model model) {
        Dataset ds = DatasetFactory.wrap((Model)model);
        return RDFDataSources.of(ds);
    }

    public static RDFDataSource of(Dataset dataset) {
        return new RDFDataSourceOverDataset(dataset);
    }

    public static RDFDataSource of(Dataset dataset, final Supplier<RDFConnection> connectionFactory) {
        return new RDFDataSourceOverDataset(dataset){

            @Override
            public RDFConnection getConnection() {
                RDFConnection r = (RDFConnection)connectionFactory.get();
                return r;
            }
        };
    }

    public static <T> T exec(RDFDataSource dataSource, Query query, Function<? super QueryExecution, T> qeToResult) {
        Object[] tmp = new Object[]{null};
        try (RDFConnection conn = dataSource.getConnection();){
            Txn.executeRead((Transactional)conn, () -> {
                try (QueryExecution qe = conn.query(query);){
                    tmp[0] = qeToResult.apply(qe);
                }
            });
        }
        Object result = tmp[0];
        return (T)result;
    }

    public static RDFEngine setupRdfDataSource(Map<String, Object> options) throws Exception {
        RdfDataSourceSpecBasicFromMap spec = RdfDataSourceSpecBasicFromMap.wrap(options);
        String sourceType = Optional.ofNullable(spec.getEngine()).orElse("mem");
        RDFEngineFactory factory = RDFEngineFactoryRegistry.get().getFactory(sourceType);
        if (factory == null) {
            throw new RuntimeException("No RdfDataSourceFactory registered under name " + sourceType);
        }
        RDFEngine result = factory.create(options);
        return result;
    }

    public static <T> T compute(RDFDataSource dataSource, Function<RDFConnection, T> computation) {
        T result;
        try (RDFConnection conn = dataSource.getConnection();){
            result = computation.apply(conn);
        }
        return result;
    }

    public static String fetchDatasetHash(RDFDataSource dataSource) {
        String result = QueryExecutionFactories.fetchDatasetHash(dataSource.asQef());
        return result;
    }

    @Deprecated
    public static RDFDataSource ofQueryConnection(SparqlQueryConnection conn) {
        return new RDFDataSourceOverSparqlQueryConnection(new RDFConnectionModular(conn, null, null));
    }

    public static RDFDataSource decorate(RDFDataSource base, RdfDataSourceTransform transform) {
        RDFDataSource result = (RDFDataSource)transform.apply(base);
        return result;
    }

    public static RDFDataSource decorate(RDFDataSource base, RDFLinkTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, QueryTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, QueryExecTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, UpdateRequestTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, RDFLinkSourceTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, LinkSparqlQueryTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, SparqlStmtTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, Rewrite transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource decorate(RDFDataSource base, ExprTransform transform) {
        RdfDataSourceTransform tmp = org.aksw.jenax.dataaccess.sparql.datasource.RdfDataSourceTransforms.of(transform);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource execQueryViaSelect(RDFDataSource base, Predicate<Query> query) {
        LinkSparqlQueryTransform tmp = RDFLinkSources.execQueryViaSelect(query);
        return RDFDataSources.decorate(base, tmp);
    }

    public static RDFDataSource wrapWithMacros(RDFDataSource base, Map<String, UserDefinedFunctionDefinition> udfRegistry) {
        return RDFDataSources.decorate(base, linkSource -> RDFLinkSources.wrapWithMacros(linkSource, udfRegistry));
    }

    public static class RDFDataSourceOverSparqlQueryConnection
    implements RDFDataSource {
        protected RDFConnection conn;

        public RDFDataSourceOverSparqlQueryConnection(RDFConnection conn) {
            this.conn = conn;
        }

        @Override
        public RDFConnection getConnection() {
            return RDFConnectionUtils.withCloseShield(this.conn);
        }
    }
}

