/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.factory.dataengine;

import java.io.Closeable;
import java.util.Deque;
import java.util.Objects;
import java.util.Optional;
import org.aksw.commons.util.exception.FinallyRunAll;
import org.aksw.jenax.dataaccess.sparql.engine.RDFEngine;
import org.aksw.jenax.dataaccess.sparql.engine.ServiceControl;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;

public class DecoratedRDFEngine<X extends RDFEngine>
implements RDFEngine {
    protected X baseEngine;
    protected RDFLinkSource effectiveLinkSource;
    protected Deque<Closeable> closeActions;

    public DecoratedRDFEngine(X baseEngine, RDFLinkSource effectiveLinkSource, Deque<Closeable> closeActions) {
        this.baseEngine = (RDFEngine)Objects.requireNonNull(baseEngine);
        this.effectiveLinkSource = Objects.requireNonNull(effectiveLinkSource);
        this.closeActions = Objects.requireNonNull(closeActions);
    }

    public X getBaseEngine() {
        return this.baseEngine;
    }

    @Override
    public Optional<ServiceControl> getServiceControl() {
        return this.baseEngine.getServiceControl();
    }

    @Override
    public RDFLinkSource getLinkSource() {
        return this.effectiveLinkSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        try {
            FinallyRunAll closer = FinallyRunAll.create();
            for (Closeable closeAction : this.closeActions) {
                closer.addThrowing(closeAction::close);
            }
            closer.run();
        }
        finally {
            this.baseEngine.close();
        }
    }
}

