/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.datasource;

import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactories;
import org.aksw.jenax.dataaccess.sparql.factory.execution.query.QueryExecutionFactory;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSource;
import org.aksw.jenax.dataaccess.sparql.linksource.RDFLinkSourceAdapter;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionBuilder;
import org.apache.jena.rdfconnection.RDFConnection;
import org.apache.jena.sparql.exec.QueryExecBuilder;
import org.apache.jena.sparql.exec.QueryExecutionBuilderAdapter;
import org.apache.jena.sparql.exec.UpdateExecBuilder;
import org.apache.jena.sparql.exec.UpdateExecutionBuilderAdapter;
import org.apache.jena.update.Update;
import org.apache.jena.update.UpdateExecutionBuilder;
import org.apache.jena.update.UpdateRequest;

@FunctionalInterface
public interface RDFDataSource {
    public RDFConnection getConnection();

    default public Dataset getDataset() {
        return null;
    }

    default public RDFLinkSource asLinkSource() {
        return RDFLinkSourceAdapter.adapt(this);
    }

    default public QueryExecutionBuilder newQuery() {
        RDFLinkSource linkSource = this.asLinkSource();
        QueryExecBuilder execBuilder = linkSource.newQuery();
        return QueryExecutionBuilderAdapter.adapt((QueryExecBuilder)execBuilder);
    }

    default public UpdateExecutionBuilder newUpdate() {
        RDFLinkSource linkSource = this.asLinkSource();
        UpdateExecBuilder execBuilder = linkSource.newUpdate();
        return UpdateExecutionBuilderAdapter.adapt((UpdateExecBuilder)execBuilder);
    }

    default public QueryExecution query(String queryString) {
        return this.newQuery().query(queryString).build();
    }

    default public QueryExecution query(Query query) {
        return this.newQuery().query(query).build();
    }

    default public void update(String updateRequestString) {
        this.newUpdate().update(updateRequestString).execute();
    }

    default public void update(UpdateRequest updateRequest) {
        this.newUpdate().update(updateRequest).execute();
    }

    default public void update(Update update) {
        this.newUpdate().update(update).execute();
    }

    @Deprecated
    default public QueryExecutionFactory asQef() {
        return QueryExecutionFactories.of(this);
    }
}

