/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.jenax.dataaccess.sparql.connection.common;

import org.aksw.jenax.arq.util.query.QueryTransform;
import org.aksw.jenax.dataaccess.sparql.connection.common.RDFConnectionUtils;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdfconnection.RDFConnection;

public class RDFConnectionBuilder<T, P> {
    protected P parent;
    protected T connection;

    public static <T extends RDFConnection> RDFConnectionBuilder<T, ?> start() {
        RDFConnectionBuilder<T, Object> result = new RDFConnectionBuilder<T, Object>(null);
        return result;
    }

    public static <T extends RDFConnection> RDFConnectionBuilder<T, ?> from(T conn) {
        RDFConnectionBuilder<T, Object> result = new RDFConnectionBuilder<T, Object>(null);
        result.setSource(conn);
        return result;
    }

    public RDFConnectionBuilder(P parent) {
        this.parent = parent;
    }

    public RDFConnectionBuilder<T, P> defaultModel() {
        this.setSource((T)ModelFactory.createDefaultModel());
        return this;
    }

    public RDFConnectionBuilder<T, P> defaultDataset() {
        this.setSource((T)DatasetFactory.create());
        return this;
    }

    public RDFConnectionBuilder<T, P> setSource(Model model) {
        this.setSource((T)DatasetFactory.wrap((Model)model));
        return this;
    }

    public RDFConnectionBuilder<T, P> setSource(Dataset dataset) {
        this.connection = RDFConnection.connect((Dataset)dataset);
        return this;
    }

    public RDFConnectionBuilder<T, P> setSource(T connection) {
        this.connection = connection;
        return this;
    }

    public RDFConnectionBuilder<RDFConnection, P> addQueryTransform(QueryTransform queryTransform) {
        RDFConnection r = RDFConnectionUtils.wrapWithQueryTransform((RDFConnection)this.connection, queryTransform, null);
        return new RDFConnectionBuilder<RDFConnection, Object>(null).setSource(r);
    }

    public T getConnection() {
        return this.connection;
    }

    public P end() {
        return this.parent;
    }
}

